/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.provider.SecretKeyRC2;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public class KeyFactoryRC2
extends SecretKeyFactorySpi {
    public SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            SecretKeySpec dks = (SecretKeySpec)keySpec;
            return new SecretKeyRC2(dks.getEncoded());
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("keySpec must be javax.crypto.spec.SecretKeySpec");
        }
    }

    public KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (!keySpec.getName().equals("javax.crypto.spec.SecretKeySpec")) {
            throw new InvalidKeySpecException("Only javax.crypto.spec.SecretKeySpec is supported");
        }
        byte[] k = key.getEncoded();
        if (k == null) {
            throw new InvalidKeySpecException("Invalid key. getEncoded returned null");
        }
        return new SecretKeySpec(k, "RC2");
    }

    public SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        byte[] k = key.getEncoded();
        if (k == null) {
            throw new InvalidKeyException("Key material is null");
        }
        return new SecretKeyRC2(k);
    }
}

