/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.des.DesKeyUtil;
import com.cryptomathic.crypto.provider.SecretKey3Des;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class KeyGenerator3Des
extends KeyGeneratorSpi {
    private SecureRandom _sr = null;

    protected void engineInit(SecureRandom sr) {
        this._sr = sr;
    }

    protected void engineInit(AlgorithmParameterSpec aps, SecureRandom sr) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not supported.");
    }

    protected void engineInit(int keysize, SecureRandom sr) {
        throw new InvalidParameterException("Not supported.");
    }

    protected SecretKey engineGenerateKey() {
        SecretKey3Des key;
        if (this._sr == null) {
            Date _now = new Date();
            try {
                this._sr = SecureRandom.getInstance("SHA1PRNG", "Cryptomathic");
                this._sr.setSeed(_now.toString().getBytes());
            }
            catch (Exception ex) {
                this._sr = new SecureRandom();
                this._sr.setSeed(_now.toString().getBytes());
            }
        }
        byte[] newfirstkey = new byte[8];
        byte[] newsecondkey = new byte[8];
        byte[] newkey = new byte[16];
        boolean strongKeyFound = false;
        while (!strongKeyFound) {
            this._sr.nextBytes(newfirstkey);
            DesKeyUtil.forceOddParity(newfirstkey);
            if (!DesKeyUtil.isKeyStrong(newfirstkey)) continue;
            strongKeyFound = true;
        }
        strongKeyFound = false;
        while (!strongKeyFound) {
            this._sr.nextBytes(newsecondkey);
            DesKeyUtil.forceOddParity(newsecondkey);
            if (!DesKeyUtil.isKeyStrong(newsecondkey)) continue;
            strongKeyFound = true;
        }
        System.arraycopy(newfirstkey, 0, newkey, 0, 8);
        System.arraycopy(newsecondkey, 0, newkey, 8, 8);
        try {
            key = new SecretKey3Des(newkey);
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        return key;
    }
}

