/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.provider;

import com.cryptomathic.crypto.des.DesMech;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesType;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.crypto.provider.SecretKey3Des;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public class MacRetailCBC
extends MacSpi {
    private byte[] _buffer = new byte[256];
    private boolean _initialized = false;
    private int _usedbuffer = 0;
    private SecretKey3Des _key = null;

    public void engineUpdate(byte b) {
        if (!this._initialized) {
            throw new InvalidParameterException("Mac not initialised");
        }
        if (this._usedbuffer == this._buffer.length) {
            byte[] tmp = new byte[2 * this._buffer.length];
            System.arraycopy(this._buffer, 0, tmp, 0, this._usedbuffer);
            this._buffer = tmp;
        }
        this._buffer[this._usedbuffer++] = b;
    }

    public void engineUpdate(byte[] b, int offset, int length) {
        if (!this._initialized) {
            throw new InvalidParameterException("Mac not initialised");
        }
        while (this._usedbuffer + length >= this._buffer.length) {
            byte[] tmp = new byte[2 * this._buffer.length];
            System.arraycopy(this._buffer, 0, tmp, 0, this._usedbuffer);
            this._buffer = tmp;
        }
        System.arraycopy(b, offset, this._buffer, this._usedbuffer, length);
        this._usedbuffer += length;
    }

    public void engineInit(Key k, AlgorithmParameterSpec aps) {
        if (!(k instanceof SecretKey3Des)) {
            throw new InvalidParameterException("wrong key format");
        }
        this._key = (SecretKey3Des)k;
        this._usedbuffer = 0;
        this._initialized = true;
    }

    public int engineGetMacLength() {
        return 8;
    }

    public void engineReset() {
        this._usedbuffer = 0;
    }

    public byte[] engineDoFinal() {
        if (!this._initialized || this._key == null) {
            throw new InvalidParameterException("Mac not initialised");
        }
        byte[] b = new byte[8];
        byte[] deskey = this._key.getEncoded();
        DesType destype = DesType.DES;
        DesMode mode = DesMode.ANSIMAC;
        PadMode pmode = PadMode.OPAD;
        int len = this._usedbuffer;
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        try {
            b = DesMech.des_mes(destype, mode, pmode, deskey, iv, this._buffer, len);
        }
        catch (Exception e) {
            throw new InvalidParameterException(e.getMessage());
        }
        return b;
    }
}

