/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.rc2;

import com.cryptomathic.crypto.pad.EBadPadding;
import com.cryptomathic.crypto.pad.Pad;
import com.cryptomathic.crypto.rc2.rc2Kernel;

public final class rc2cbc {
    public static final byte[] encrypt(byte[] mes, byte[] key, int ekb, byte[] iv, int pmode) {
        byte[] omes;
        if (iv == null || iv.length != 8) {
            throw new IllegalArgumentException("Illegal iv");
        }
        int[] exp_key = rc2Kernel.makekeys(key, ekb);
        if (pmode != 0) {
            omes = new byte[mes.length - mes.length % 8 + 8];
            System.arraycopy(mes, 0, omes, 0, mes.length);
            Pad.pad(omes, omes.length - 8, mes.length - omes.length + 8, 8, pmode);
        } else {
            if ((mes.length & 7) != 0) {
                throw new IllegalArgumentException("Illegal input length for no padding");
            }
            omes = new byte[mes.length];
            System.arraycopy(mes, 0, omes, 0, mes.length);
        }
        for (int i = 0; i < omes.length; i += 8) {
            int j;
            if (i == 0) {
                for (j = 0; j < 8; ++j) {
                    int n = j;
                    omes[n] = (byte)(omes[n] ^ iv[j]);
                }
            } else {
                for (j = i; j < i + 8; ++j) {
                    int n = j;
                    omes[n] = (byte)(omes[n] ^ omes[j - 8]);
                }
            }
            rc2Kernel.encrypt(exp_key, omes, i);
        }
        return omes;
    }

    public static final byte[] decrypt(byte[] mes, byte[] key, int ekb, byte[] iv, int pmode) throws EBadPadding {
        if (iv == null || iv.length != 8) {
            throw new IllegalArgumentException("Illegal iv");
        }
        int[] exp_key = rc2Kernel.makekeys(key, ekb);
        for (int i = mes.length - 8; i >= 0; i -= 8) {
            int j;
            rc2Kernel.decrypt(exp_key, mes, i);
            if (i == 0) {
                for (j = 0; j < 8; ++j) {
                    int n = j;
                    mes[n] = (byte)(mes[n] ^ iv[j]);
                }
                continue;
            }
            for (j = i; j < i + 8; ++j) {
                int n = j;
                mes[n] = (byte)(mes[n] ^ mes[j - 8]);
            }
        }
        int significant_bytes = Pad.unpad(mes, mes.length - 8, 8, pmode);
        byte[] res = new byte[mes.length - 8 + significant_bytes];
        System.arraycopy(mes, 0, res, 0, res.length);
        return res;
    }
}

