/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ecc.ASN1.CharacteristicTwoParameters;
import com.cryptomathic.ecc.ASN1.Pentanomial;
import com.cryptomathic.ecc.gf2.Field;
import java.util.Vector;

public class CharacteristicTwo
extends Sequence {
    public ASN1Integer m;
    public ObjectIdentifier basis;
    public CharacteristicTwoParameters parameters;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.m = (ASN1Integer)v.elementAt(0);
        this.basis = (ObjectIdentifier)v.elementAt(1);
        this.parameters = (CharacteristicTwoParameters)v.elementAt(2);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(3);
        v.addElement(this.m);
        v.addElement(this.basis);
        v.addElement(this.parameters);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(ObjectIdentifier.class);
        template.addAnyDefinedByMember(CharacteristicTwoParameters.class, 1);
        return template;
    }

    public CharacteristicTwo() {
    }

    public CharacteristicTwo(ObjectIdentifier obj, ASN1Object value) throws ASN1Exception {
        this.basis = obj;
        this.parameters = new CharacteristicTwoParameters();
        this.parameters.setAnyDefinedBy(obj);
        this.parameters = (CharacteristicTwoParameters)value;
    }

    public void init(Field field) throws ASN1Exception {
        this.m = new ASN1Integer(field.degree());
        int[] coefficients = field.f.coefficients();
        if (coefficients.length == 3) {
            this.basis = new ObjectIdentifier("1.2.840.10045.1.2.3.2");
            this.parameters = new CharacteristicTwoParameters(new ASN1Integer(coefficients[1]));
        } else if (coefficients.length == 5) {
            this.basis = new ObjectIdentifier("1.2.840.10045.1.2.3.3");
            Pentanomial p = new Pentanomial(coefficients);
            this.parameters = new CharacteristicTwoParameters(p);
        } else {
            throw new ASN1Exception("Field is not supported");
        }
    }

    public CharacteristicTwo(Field field) throws ASN1Exception {
        this.init(field);
    }
}

