/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ecc.ASN1.Curve;
import com.cryptomathic.ecc.ASN1.FieldID;
import java.util.Vector;

public class ECParameters
extends Sequence {
    public ASN1Integer version;
    public FieldID fieldID;
    public Curve curve;
    public OctetString base;
    public ASN1Integer order;
    public ASN1Integer cofactor;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.elementAt(0);
        this.fieldID = (FieldID)v.elementAt(1);
        this.curve = (Curve)v.elementAt(2);
        this.base = (OctetString)v.elementAt(3);
        this.order = (ASN1Integer)v.elementAt(4);
        this.cofactor = (ASN1Integer)v.elementAt(5);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(6);
        v.addElement(this.version);
        v.addElement(this.fieldID);
        v.addElement(this.curve);
        v.addElement(this.base);
        v.addElement(this.order);
        v.addElement(this.cofactor);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(FieldID.class);
        template.addMember(Curve.class);
        template.addMember(OctetString.class);
        template.addMember(ASN1Integer.class);
        template.addOptionalMember(ASN1Integer.class);
        return template;
    }

    public ECParameters() {
    }

    public ECParameters(com.cryptomathic.ecc.Curve curve) throws ASN1Exception {
        this.version = new ASN1Integer(1);
        this.fieldID = new FieldID(curve.getField());
        this.curve = new Curve(curve);
        this.base = new OctetString(curve.getG().toByteArray());
        this.order = new ASN1Integer(curve.getOrder());
    }
}

