/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ecc.ASN1.CharacteristicTwo;
import com.cryptomathic.ecc.ASN1.FieldType;
import com.cryptomathic.ecc.Field;
import java.util.Vector;

public class FieldID
extends Sequence {
    public ObjectIdentifier fieldType;
    public FieldType parameters;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.fieldType = (ObjectIdentifier)v.elementAt(0);
        this.parameters = (FieldType)v.elementAt(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.addElement(this.fieldType);
        v.addElement(this.parameters);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ObjectIdentifier.class);
        template.addAnyDefinedByMember(FieldType.class, 0);
        return template;
    }

    public FieldID() {
    }

    public FieldID(ObjectIdentifier obj, ASN1Object value) throws ASN1Exception {
        this.fieldType = obj;
        this.parameters = new FieldType();
        this.parameters.setAnyDefinedBy(obj);
        this.parameters = (FieldType)value;
    }

    public void init(Field field) throws ASN1Exception {
        if (field instanceof com.cryptomathic.ecc.gf2.Field) {
            this.fieldType = new ObjectIdentifier("1.2.840.10045.1.2");
            CharacteristicTwo gf2 = new CharacteristicTwo((com.cryptomathic.ecc.gf2.Field)field);
            this.parameters = new FieldType(gf2);
        } else if (field instanceof com.cryptomathic.ecc.gfp.Field) {
            this.fieldType = new ObjectIdentifier("1.2.840.10045.1.1");
            this.parameters = new FieldType(new ASN1Integer(((com.cryptomathic.ecc.gfp.Field)field).getp()));
        } else {
            throw new ASN1Exception("Unsupported curve type");
        }
    }

    public FieldID(Field field) throws ASN1Exception {
        this.init(field);
    }
}

