/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ecc.ASN1.AlgorithmIdentifier;
import com.cryptomathic.ecc.ASN1.AlgorithmIdentifierParameters;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.ECPublicKey;
import java.util.Vector;

public class SubjectPublicKeyInfo
extends Sequence {
    public AlgorithmIdentifier algorithm;
    public BitString subjectPublicKey;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.algorithm = (AlgorithmIdentifier)v.elementAt(0);
        this.subjectPublicKey = (BitString)v.elementAt(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.addElement(this.algorithm);
        v.addElement(this.subjectPublicKey);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(AlgorithmIdentifier.class);
        template.addOptionalMember(BitString.class);
        return template;
    }

    public SubjectPublicKeyInfo(ECPublicKey key) throws ASN1Exception {
        this.algorithm = new AlgorithmIdentifier();
        this.algorithm.algorithm = new ObjectIdentifier(OIDs.id_ecPublicKey);
        this.algorithm.parameters = new AlgorithmIdentifierParameters(new ECParameters(key.getCurve()));
        this.subjectPublicKey = new BitString(key.getW().toByteArray(), 0);
    }

    public SubjectPublicKeyInfo() {
    }
}

