/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.ecc.ECPrivateKey;
import com.cryptomathic.ecc.ECPublicKey;
import com.cryptomathic.ecc.Point;
import com.cryptomathic.util.ByteArray;

public class ECDH {
    static final int HASHLEN = 20;

    private ECDH() {
    }

    private static byte[] int2ByteArray(int n, int len) {
        byte[] res = new byte[len];
        int k = n;
        for (int i = 1; i <= len; ++i) {
            res[len - i] = (byte)(k & 0xFF);
            k >>= 4;
        }
        return res;
    }

    private static byte[] ANSI_X963_KDF(byte[] Z, int keydatalen, byte[] sharedInfo) {
        ByteArray res = new ByteArray();
        for (int i = 1; i <= (keydatalen + 20 - 1) / 20; ++i) {
            byte[] counter = ECDH.int2ByteArray(i, 4);
            try {
                HashState hashstate = HashState.start_hash(HashType.SHA);
                hashstate.do_hash(Z);
                hashstate.do_hash(counter);
                res.append(hashstate.stop_hash(HashPadMode.NOPAD, sharedInfo, 0, sharedInfo.length));
                continue;
            }
            catch (HashException e) {
                throw new RuntimeException(e.toString());
            }
        }
        res.resize(keydatalen);
        return res.toByteArray();
    }

    public static byte[] Key_Aggreement_Operation(ECPrivateKey privateKey, ECPublicKey publicKey, int keydatalen, byte[] sharedInfo) {
        byte[] sInfo = sharedInfo == null ? new byte[]{} : sharedInfo;
        Point P = publicKey.getW().scalarMultiply(privateKey.getS());
        if (P.isInfinity()) {
            return null;
        }
        byte[] Z = P.xToByteArray();
        return ECDH.ANSI_X963_KDF(Z, keydatalen, sInfo);
    }

    public static byte[] Key_Aggreement_Operation(ECPrivateKey privateKey, ECPublicKey publicKey, int keydatalen) {
        return ECDH.Key_Aggreement_Operation(privateKey, publicKey, keydatalen, new byte[0]);
    }
}

