/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ecc.Curve;
import com.cryptomathic.ecc.ECDSASignature;
import com.cryptomathic.ecc.ECPrivateKey;
import com.cryptomathic.ecc.ECPublicKey;
import com.cryptomathic.ecc.Point;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Random;

public class ECDSA {
    private ECDSA() {
    }

    public static ECDSASignature sign(ECPrivateKey privateKey, byte[] hash, Random rnd) {
        BigInteger k;
        BigInteger k_inverse;
        BigInteger temp;
        BigInteger s;
        KeyPair ephemeral;
        Point R;
        BigInteger r;
        Curve C = privateKey.C;
        BigInteger n = C.getOrder();
        BigInteger e = new BigInteger(1, hash);
        do {
            ephemeral = C.generateKeyPair(rnd);
            k = ((ECPrivateKey)ephemeral.getPrivate()).S;
        } while ((r = (R = ((ECPublicKey)ephemeral.getPublic()).W).xtoBigInteger().mod(n)).signum() == 0 || (s = (temp = r.multiply(privateKey.S).add(e).mod(n)).multiply(k_inverse = k.modInverse(n)).mod(n)).signum() == 0);
        return new ECDSASignature(r, s);
    }

    public static boolean verify(ECPublicKey publicKey, byte[] hash, ECDSASignature signature) {
        Point T;
        Curve C = publicKey.W.getCurve();
        BigInteger n = C.getOrder();
        BigInteger r = signature.r;
        BigInteger s = signature.s;
        if (r.signum() == 0 || s.signum() == 0) {
            return false;
        }
        if (r.compareTo(n) >= 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger e = new BigInteger(1, hash);
        BigInteger s_inverse = s.modInverse(n);
        BigInteger u1 = s_inverse.multiply(e).mod(n);
        BigInteger u2 = s_inverse.multiply(r).mod(n);
        Point S = C.getG().scalarMultiply(u1);
        BigInteger v = S.addXCoordstoBigInteger(T = publicKey.W.scalarMultiply(u2)).mod(n);
        return v.equals(r);
    }
}

