/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.ecc.ECDSA;
import com.cryptomathic.ecc.ECDSASignature;
import com.cryptomathic.ecc.ECPrivateKey;
import com.cryptomathic.ecc.ECPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;

public class ECDSAProvider
extends Signature {
    private ECPrivateKey _privateKey;
    private ECPublicKey _publicKey;
    private HashState hashState;

    public ECDSAProvider() {
        super("ECDSA");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("No parameters used");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof ECPrivateKey) {
            this._privateKey = (ECPrivateKey)privateKey;
            this._publicKey = null;
            try {
                this.hashState = HashState.start_hash(HashType.SHA);
            }
            catch (HashException e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            throw new InvalidKeyException("No support for this type of key! (" + privateKey.getClass().getName() + ")");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof ECPublicKey) {
            this._privateKey = null;
            this._publicKey = (ECPublicKey)publicKey;
            try {
                this.hashState = HashState.start_hash(HashType.SHA);
            }
            catch (HashException e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            throw new InvalidKeyException("No support for this type of key! (" + publicKey.getClass().getName() + ")");
        }
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("No parameters used");
    }

    protected byte[] engineSign() throws SignatureException {
        SecureRandom rnd = new SecureRandom();
        try {
            return ECDSA.sign(this._privateKey, this.hashState.stop_hash(HashPadMode.NOPAD), rnd).toByteArray();
        }
        catch (ASN1Exception e) {
            throw new SignatureException("ASN1Exception:" + e);
        }
        catch (HashException e) {
            throw new SignatureException("HashException:" + e);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        byte[] barray = new byte[]{b};
        this.hashState.do_hash(barray, 0, 1);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.hashState.do_hash(b, off, len);
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            return ECDSA.verify(this._publicKey, this.hashState.stop_hash(HashPadMode.NOPAD), new ECDSASignature(sigBytes));
        }
        catch (ASN1Exception e) {
            throw new SignatureException("ASN1Exception:" + e);
        }
        catch (HashException e) {
            throw new SignatureException("HashException:" + e);
        }
    }
}

