/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ecc.ASN1.ECDSA_Sig_Value;
import java.math.BigInteger;

public class ECDSASignature {
    BigInteger r;
    BigInteger s;

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public ECDSASignature(byte[] sigBytes) throws ASN1Exception {
        ECDSA_Sig_Value value = new ECDSA_Sig_Value();
        value.decode(sigBytes);
        this.r = value.r.getBigInteger();
        this.s = value.s.getBigInteger();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public byte[] toByteArray() throws ASN1Exception {
        ECDSA_Sig_Value value = new ECDSA_Sig_Value();
        value.r = new ASN1Integer(this.r);
        value.s = new ASN1Integer(this.s);
        return value.encode();
    }
}

