/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.ASN1.SubjectPublicKeyInfo;
import com.cryptomathic.ecc.Curve;
import com.cryptomathic.ecc.ECDSA;
import com.cryptomathic.ecc.ECDSASignature;
import com.cryptomathic.ecc.Point;
import java.security.PublicKey;

public class ECPublicKey
implements PublicKey {
    Point W;

    public ECPublicKey(Point Q) {
        this.W = Q;
    }

    private void init(SubjectPublicKeyInfo spki) throws ASN1Exception {
        this.W = Point.decode(spki.subjectPublicKey.getAsByteString(), (ECParameters)spki.algorithm.parameters.value);
    }

    public ECPublicKey(SubjectPublicKeyInfo spki) throws ASN1Exception {
        this.init(spki);
    }

    public ECPublicKey(byte[] encoding) throws ASN1Exception {
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
        spki.decode(encoding);
        this.init(spki);
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo asn1 = new SubjectPublicKeyInfo(this);
            return asn1.encode();
        }
        catch (ASN1Exception e) {
            return null;
        }
    }

    public String getAlgorithm() {
        return "EC";
    }

    public String getFormat() {
        return null;
    }

    public Point getW() {
        return this.W;
    }

    public boolean verify_ECDSA(byte[] hash, ECDSASignature signature) {
        return ECDSA.verify(this, hash, signature);
    }

    public boolean validate() {
        if (this.W.isInfinity()) {
            return false;
        }
        if (!this.W.isOnCurve()) {
            return false;
        }
        Point nQ = this.W.scalarMultiply(this.W.getCurve().getOrder());
        return nQ.isInfinity();
    }

    public Curve getCurve() {
        return this.W.getCurve();
    }
}

