/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.crypto.util.Primality;
import com.cryptomathic.ecc.ASN1.CharacteristicTwo;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.Point;
import com.cryptomathic.ecc.gf2.DomainParameters;
import com.cryptomathic.ecc.gf2.Field;
import com.cryptomathic.ecc.gf2.FieldElement;
import com.cryptomathic.ecc.gf2.PointElement;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;

public class Curve
extends com.cryptomathic.ecc.Curve {
    FieldElement a;
    FieldElement b;
    Field F;
    PointElement G;
    BigInteger order;

    Curve(Curve C) {
        this.a = C.a;
        this.b = C.b;
        this.F = C.F;
        this.G = C.G;
        this.order = C.order;
    }

    Curve(Field F, FieldElement a, FieldElement b, PointElement G, BigInteger order) {
        this.F = F;
        this.a = a;
        this.b = b;
        this.G = G;
        this.order = order;
    }

    public Curve(DomainParameters curve) {
        this.F = curve.F;
        this.a = curve.a;
        this.b = curve.b;
        this.G = curve.G;
        this.order = curve.order;
    }

    public Curve(ECParameters curve) throws ASN1Exception {
        this.F = new Field((CharacteristicTwo)curve.fieldID.parameters.value);
        this.a = new FieldElement(curve.curve.a, this.F);
        this.b = new FieldElement(curve.curve.b, this.F);
        this.G = new PointElement(curve.base.value, this.F);
        this.order = curve.order.getBigInteger();
    }

    private int getDegree() {
        return this.F.degree();
    }

    public com.cryptomathic.ecc.Field getField() {
        return this.F;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public Point getG() {
        return new com.cryptomathic.ecc.gf2.Point(this.G, this);
    }

    public static Curve K163() {
        Field F = new Field(163, 7, 6, 3, 0);
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("02fe13c0537bbc11acaa07d793de4e6d5e5c94eee8"), F), new FieldElement(ByteArray.toByteArray("0289070fb05d38ff58321f2e800536d538ccdaa3d9"), F));
        BigInteger order = new BigInteger("04000000000000000000020108a2e0cc0d99f8a5ef", 16);
        return new Curve(F, FieldElement.One(F), FieldElement.One(F), G, order);
    }

    public static Curve B191() {
        Field F = new Field(191, 9, 0);
        PointElement G = new PointElement(ByteArray.toByteArray("0436B3DAF8A23206F9C4F299D7B21A9C369137F2C84AE1AA0D765BE73433B3F95E332932E70EA245CA2418EA0EF98018FB"), F);
        BigInteger order = new BigInteger("1569275433846670190958947355803350458831205595451630533029");
        FieldElement a = new FieldElement(ByteArray.toByteArray("2866537B676752636A68F56554E12640276B649EF7526267"), F);
        FieldElement b = new FieldElement(ByteArray.toByteArray("2E45EF571F00786F67B0081B9495A3D95462F5DE0AA185EC"), F);
        return new Curve(F, a, b, G, order);
    }

    public static Curve B233() {
        Field F = new Field(233, 74, 0);
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("00FAC9DFCBAC8313BB2139F1BB755FEF65BC391F8B36F8F8EB7371FD558B"), F), new FieldElement(ByteArray.toByteArray("01006A08A41903350678E58528BEBF8A0BEFF867A7CA36716F7E01F81052"), F));
        BigInteger order = new BigInteger("01000000000000000000000000000013E974E72F8A6922031D2603CFE0D7", 16);
        return new Curve(F, FieldElement.One(F), new FieldElement(ByteArray.toByteArray("0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90AD"), F), G, order);
    }

    public boolean validate() {
        if (this.b.isZero()) {
            return false;
        }
        if (!this.G.isOnCurve(this)) {
            return false;
        }
        Primality primality = new Primality();
        if (!primality.isProbablePrime(this.order, 100)) {
            return false;
        }
        int log2n = this.order.bitLength();
        if (log2n <= 160) {
            return false;
        }
        if (log2n <= this.getDegree() / 2 + 2) {
            return false;
        }
        if (!com.cryptomathic.ecc.gf2.Point.scalarMultiply(this.G, this.order, this).isInfinity()) {
            return false;
        }
        BigInteger q = BigInteger.valueOf(2L).pow(this.getDegree());
        if (!Curve.MOVcondition(q, this.order)) {
            return false;
        }
        return !q.equals(this.order);
    }

    public boolean equals(Curve C) {
        return this.a.equals(C.a) && this.b.equals(C.b) && this.F.equals(C.F) && this.G.equals(C.G) && this.order.equals(C.order);
    }

    public boolean equals(Object x) {
        if (!(x instanceof Curve)) {
            return false;
        }
        return this.equals((Curve)x);
    }

    public byte[] getA() {
        return this.a.toByteArray();
    }

    public byte[] getB() {
        return this.b.toByteArray();
    }

    public String toString() {
        return "a: " + this.a.toString() + ", " + "b: " + this.b.toString() + ", " + "F: " + this.F.toString() + ", " + "G: " + this.G.toString() + ", " + "Order: " + this.order.toString();
    }
}

