/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ecc.gf2.Field;
import com.cryptomathic.ecc.gf2.FieldElement;
import com.cryptomathic.ecc.gf2.PointElement;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;

public class DomainParameters {
    PointElement G;
    FieldElement a;
    FieldElement b;
    BigInteger order;
    Field F;
    public static final DomainParameters K163 = new DomainParameters(163, "02fe13c0537bbc11acaa07d793de4e6d5e5c94eee8", "0289070fb05d38ff58321f2e800536d538ccdaa3d9", "4000000000000000000020108a2e0cc0d99f8a5ef", "01", "01", 7, 6, 3);
    public static final DomainParameters sect163r1 = new DomainParameters(163, "0369979697AB43897789566789567F787A7876A654", "00435EDB42EFAFB2989D51FEFCE3C80988F41FF883", "3FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279B", "07B6882CAAEFA84F9554FF8428BD88E246D2782AE2", "0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9", 7, 6, 3);
    public static final DomainParameters sect163r2 = new DomainParameters(163, "03F0EBA16286A2D57EA0991168D4994637E8343E36", "00D51FBC6C71A0094FA2CDD545B11C5C0C797324F1", "40000000000000000000292FE77E70C12A4234C33", "01", "020A601907B8C953CA1481EB10512F78744A3205FD", 7, 6, 3);
    public static final DomainParameters K233 = new DomainParameters(233, "017232BA853A7E731AF129F22FF4149563A419C26BF50A4C9D6EEFAD6126", "01DB537DECE819B7F70F555A67C427A8CD9BF18AEB9B56E0C11056FAE6A3", "8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDF", "00", "01", 74);
    public static final DomainParameters B233 = new DomainParameters(233, "00FAC9DFCBAC8313BB2139F1BB755FEF65BC391F8B36F8F8EB7371FD558B", "01006A08A41903350678E58528BEBF8A0BEFF867A7CA36716F7E01F81052", "01000000000000000000000000000013E974E72F8A6922031D2603CFE0D7", "01", "0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90AD", 74);
    public static final DomainParameters K283 = new DomainParameters(283, "0503213F78CA44883F1A3B8162F188E553CD265F23C1567A16876913B0C2AC2458492836", "01CCDA380F1C9E318D90F95D07E5426FE87E45C0E8184698E45962364E34116177DD2259", "1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE9AE2ED07577265DFF7F94451E061E163C61", "00", "01", 12, 7, 5);
    public static final DomainParameters B283 = new DomainParameters(283, "05F939258DB7DD90E1934F8C70B0DFEC2EED25B8557EAC9C80E2E198F8CDBECD86B12053", "03676854FE24141CB98FE6D4B20D02B4516FF702350EDDB0826779C813F0DF45BE8112F4", "3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307", "01", "027B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5", 12, 7, 5);

    public DomainParameters(int degree, String Gx, String Gy, String order, String a, String b, int coef1) {
        this.F = new Field(degree, coef1, 0);
        this.G = new PointElement(new FieldElement(ByteArray.toByteArray(Gx), this.F), new FieldElement(ByteArray.toByteArray(Gy), this.F));
        this.a = new FieldElement(ByteArray.toByteArray(a), this.F);
        this.b = new FieldElement(ByteArray.toByteArray(b), this.F);
        this.order = new BigInteger(order, 16);
    }

    public DomainParameters(int degree, String Gx, String Gy, String order, String a, String b, int coef1, int coef2, int coef3) {
        this.F = new Field(degree, coef1, coef2, coef3, 0);
        this.G = new PointElement(new FieldElement(ByteArray.toByteArray(Gx), this.F), new FieldElement(ByteArray.toByteArray(Gy), this.F));
        this.a = new FieldElement(ByteArray.toByteArray(a), this.F);
        this.b = new FieldElement(ByteArray.toByteArray(b), this.F);
        this.order = new BigInteger(order, 16);
    }
}

