/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ecc.gf2.Field;
import com.cryptomathic.ecc.gf2.Polynomial;
import java.math.BigInteger;

class FieldElement {
    private Polynomial pol;
    private Field F;

    public static FieldElement Zero(Field F) {
        FieldElement res = new FieldElement(F);
        res.pol = new Polynomial(F.degree() - 1);
        return res;
    }

    public static FieldElement One(Field F) {
        FieldElement res = new FieldElement(F);
        res.pol = new Polynomial(F.degree() - 1, 1);
        return res;
    }

    private FieldElement(Field F) {
        this.F = F;
    }

    public FieldElement(Polynomial pol, Field F) {
        this.pol = pol;
        this.F = F;
    }

    public FieldElement(FieldElement e) {
        this.pol = e.pol;
        this.F = e.F;
    }

    public FieldElement(OctetString fe, Field F) {
        this(fe.value, F);
    }

    public byte[] toByteArray() {
        return this.pol.toByteArray();
    }

    public FieldElement(byte[] serialization, Field F) {
        this.pol = new Polynomial(F.degree() - 1, serialization);
        this.F = F;
    }

    public BigInteger toBigInteger() {
        return this.pol.toBigInteger();
    }

    public boolean equals(FieldElement e) {
        return this.pol.equals(e.pol);
    }

    public boolean isZero() {
        return this.pol.isZero();
    }

    public void add(FieldElement b) {
        this.pol.add(b.pol);
    }

    public void set(int n) {
        this.pol.set(n);
    }

    public void assign(FieldElement a) {
        this.pol.assign(a.pol);
    }

    public static FieldElement add(FieldElement a, FieldElement b) {
        FieldElement res = new FieldElement(a.F);
        res.pol = Polynomial.add(a.pol, b.pol);
        return res;
    }

    public void multiply(FieldElement a) {
        this.pol = this.pol.multiply(a.pol);
        this.F.reduce(this.pol);
    }

    public static FieldElement multiply(FieldElement a, FieldElement b) {
        FieldElement res = new FieldElement(a.F);
        res.pol = Polynomial.multiply(a.pol, b.pol);
        a.F.reduce(res.pol);
        return res;
    }

    public void square() {
        this.pol = this.pol.square();
        this.F.reduce(this.pol);
    }

    public static FieldElement square(FieldElement a) {
        FieldElement res = new FieldElement(a.F);
        res.pol = Polynomial.square(a.pol);
        a.F.reduce(res.pol);
        return res;
    }

    public static FieldElement exp(FieldElement f, BigInteger exponent) {
        FieldElement a = FieldElement.One(f.F);
        int length = exponent.bitLength();
        for (int i = length - 1; i >= 0; --i) {
            a.square();
            if (!exponent.testBit(i)) continue;
            a.multiply(f);
        }
        return a;
    }

    public void exp(BigInteger exponent) {
        this.pol = FieldElement.exp((FieldElement)this, (BigInteger)exponent).pol;
    }

    public static FieldElement inverseByExp(FieldElement f) {
        BigInteger exponent = new BigInteger("2");
        exponent = exponent.pow(f.F.degree());
        exponent = exponent.subtract(new BigInteger("2"));
        return FieldElement.exp(f, exponent);
    }

    public static FieldElement inverseByXGCD(FieldElement a) {
        Polynomial b = new Polynomial(a.F.degree() - 1, 1);
        Polynomial c = new Polynomial(a.F.degree() - 1);
        Polynomial u = new Polynomial(a.pol);
        Polynomial v = new Polynomial(a.F.f);
        while (!u.isZeroOrOne()) {
            int j = u.degree() - v.degree();
            if (j < 0) {
                Polynomial t = u;
                u = v;
                v = t;
                t = b;
                b = c;
                c = t;
                j = -j;
            }
            u.add(Polynomial.shl(v, j));
            b.add(Polynomial.shl(c, j));
        }
        return new FieldElement(b, a.F);
    }

    public static FieldElement inverseByPower(FieldElement a) {
        int mask;
        FieldElement fn = new FieldElement(a);
        int m = a.F.degree() - 1;
        for (mask = 1; mask < m; mask <<= 1) {
        }
        mask >>>= 2;
        int k = 1;
        do {
            FieldElement fy = new FieldElement(fn);
            for (int i = 0; i < k; ++i) {
                fy.square();
            }
            k <<= 1;
            fn.multiply(fy);
            if ((m & mask) == 0) continue;
            fn.square();
            fn.multiply(a);
            ++k;
        } while ((mask >>= 1) != 0);
        fn.square();
        return fn;
    }

    public static FieldElement inverse(FieldElement f) {
        return FieldElement.inverseByXGCD(f);
    }

    public void inverse() {
        this.pol = FieldElement.inverse((FieldElement)this).pol;
    }

    public String toString() {
        return this.pol.toString();
    }

    public String toString_pol() {
        return this.pol.toString_pol();
    }
}

