/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.util.BitString;
import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Polynomial {
    private BitString bits;
    private boolean precomputed_multiplytable = false;
    private BitString[] Bu;
    public static final int BITS_PER_UNIT = 64;

    public Polynomial(int deg) {
        this.bits = new BitString(deg + 1);
    }

    public Polynomial(int deg, byte[] bytes) {
        this.bits = new BitString(deg + 1, bytes);
    }

    public Polynomial(int deg, int low) {
        this.bits = new BitString(deg + 1, low);
    }

    public Polynomial(Polynomial f) {
        this.bits = new BitString(f.bits);
    }

    public Polynomial(BitString f) {
        this.bits = f;
    }

    public Polynomial(int deg, int[] coefs) {
        this.bits = new BitString(deg);
        for (int i = 0; i < coefs.length; ++i) {
            this.bits.set(coefs[i]);
        }
    }

    public int[] coefficients() {
        return this.bits.bits();
    }

    private static int[] stringToCoefs(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, "+ x^", true);
        int state = 0;
        Vector<Integer> coefs = new Vector<Integer>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == " ") continue;
            switch (state) {
                case 0: {
                    if (token.equals("1")) {
                        coefs.addElement(new Integer(0));
                        state = 3;
                        break;
                    }
                    if (!token.equalsIgnoreCase("x")) {
                        throw new IllegalArgumentException("Not a polynomial (expected 'x')");
                    }
                    ++state;
                    break;
                }
                case 1: {
                    if (token.equals("+")) {
                        coefs.addElement(new Integer(1));
                        state = 0;
                        break;
                    }
                    if (!token.equalsIgnoreCase("^")) {
                        throw new IllegalArgumentException("Not a polynomial (expected '^')");
                    }
                    ++state;
                    break;
                }
                case 2: {
                    Integer exp;
                    try {
                        exp = Integer.valueOf(token);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Not a polynomial (expected number)");
                    }
                    coefs.addElement(exp);
                    ++state;
                    break;
                }
                case 3: {
                    if (!token.equalsIgnoreCase("+")) {
                        throw new IllegalArgumentException("Not a polynomial  (expected '+')");
                    }
                    state = 0;
                }
            }
        }
        if (state == 1) {
            coefs.addElement(new Integer(1));
            state = 3;
        }
        if (state != 3) {
            throw new IllegalArgumentException("Not a polynomial (did not end in number)");
        }
        int[] res = new int[coefs.size()];
        for (int i = 0; i < coefs.size(); ++i) {
            res[i] = (Integer)coefs.elementAt(i);
        }
        return res;
    }

    public Polynomial(int deg, String string) {
        this(deg, Polynomial.stringToCoefs(string));
    }

    public boolean equals(Polynomial f) {
        return this.bits.equals(f.bits);
    }

    public boolean isZero() {
        return this.bits.isZero();
    }

    public boolean isZeroOrOne() {
        return this.bits.isZeroOrOne();
    }

    public void assign(Polynomial f) {
        this.invalidate();
        this.bits.assign(f.bits);
    }

    public int maxDegree() {
        return this.bits.bitLength() - 1;
    }

    public int degree() {
        return this.bits.topBit();
    }

    public void set(int n) {
        this.invalidate();
        this.bits.set(n);
    }

    public void clear(int n) {
        this.invalidate();
        this.bits.clear(n);
    }

    public void clearTopBits(int n) {
        this.bits.clearTopBits(this.maxDegree() - n);
    }

    public boolean get(int n) {
        return this.bits.get(n);
    }

    public void add(Polynomial p) {
        this.invalidate();
        this.bits.xor(p.bits);
    }

    public static Polynomial add(Polynomial a, Polynomial b) {
        Polynomial res = new Polynomial(a);
        res.bits.xor(b.bits);
        return res;
    }

    public void add(Polynomial p, int word) {
        this.invalidate();
        this.bits.xor(p.bits, word);
    }

    public void shl(int n) {
        this.invalidate();
        this.bits.shl(n);
    }

    public void shr(int n) {
        this.invalidate();
        this.bits.shr(n);
    }

    public void truncate(int n) {
        this.clearTopBits(n);
        this.bits.truncate(n + 1);
    }

    private synchronized boolean isPrecomputed() {
        return this.precomputed_multiplytable;
    }

    private synchronized void invalidate() {
        this.precomputed_multiplytable = false;
    }

    private synchronized void precompute_multiplytable() {
        if (this.precomputed_multiplytable) {
            return;
        }
        this.Bu = new BitString[16];
        this.Bu[0] = new BitString(this.maxDegree() + 1);
        this.Bu[1] = new BitString(this.bits);
        BitString bs = new BitString(this.bits, this.bits.bitLength() + 3);
        bs.shl(1);
        this.Bu[2] = new BitString(bs);
        this.Bu[3] = BitString.xor(this.Bu[1], this.Bu[2]);
        bs.shl(1);
        this.Bu[4] = new BitString(bs);
        this.Bu[5] = BitString.xor(this.Bu[1], this.Bu[4]);
        this.Bu[6] = BitString.xor(this.Bu[2], this.Bu[4]);
        this.Bu[7] = BitString.xor(this.Bu[3], this.Bu[4]);
        bs.shl(1);
        this.Bu[8] = new BitString(bs);
        this.Bu[9] = BitString.xor(this.Bu[1], this.Bu[8]);
        this.Bu[10] = BitString.xor(this.Bu[2], this.Bu[8]);
        this.Bu[11] = BitString.xor(this.Bu[3], this.Bu[8]);
        this.Bu[12] = BitString.xor(this.Bu[4], this.Bu[8]);
        this.Bu[13] = BitString.xor(this.Bu[5], this.Bu[8]);
        this.Bu[14] = BitString.xor(this.Bu[6], this.Bu[8]);
        this.Bu[15] = BitString.xor(this.Bu[7], this.Bu[8]);
        this.precomputed_multiplytable = true;
    }

    private Polynomial domultiply(Polynomial a) {
        this.precompute_multiplytable();
        BitString c = this.bits.domultiply(a.bits, this.Bu);
        return new Polynomial(c);
    }

    public static Polynomial multiply(Polynomial a, Polynomial b) {
        if (b.isPrecomputed()) {
            return b.domultiply(a);
        }
        return a.domultiply(b);
    }

    public static Polynomial shl(Polynomial a, int n) {
        Polynomial res = new Polynomial(a);
        res.shl(n);
        return res;
    }

    public Polynomial multiply(Polynomial a) {
        return Polynomial.multiply(this, a);
    }

    public static Polynomial square(Polynomial a) {
        return new Polynomial(BitString.square(a.bits));
    }

    public Polynomial square() {
        return Polynomial.square(this);
    }

    public String toString() {
        return this.bits.toString();
    }

    public String toString_pol() {
        String res = new String();
        boolean first = true;
        for (int i = this.maxDegree(); i >= 0; --i) {
            if (!this.bits.get(i)) continue;
            if (!first) {
                res = res + "+";
            } else {
                first = false;
            }
            res = i > 1 ? res + "x^" + i : (i == 1 ? res + "x" : res + "1");
        }
        if (first) {
            res = "0";
        }
        return res;
    }

    public static Polynomial RandomPolynomial(int degree, Random rnd) {
        return new Polynomial(BitString.RandomBitString(degree + 1, rnd));
    }

    public BigInteger toBigInteger() {
        return this.bits.toBigInteger();
    }

    public byte[] toByteArray() {
        return this.bits.toByteArray();
    }
}

