/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gfp;

import com.cryptomathic.ASN1.OctetString;
import java.math.BigInteger;

class FieldElement {
    private BigInteger p;
    private BigInteger value;

    public static FieldElement Zero(BigInteger p) {
        FieldElement res = new FieldElement(p);
        res.value = BigInteger.valueOf(0L);
        return res;
    }

    public static FieldElement One(BigInteger p) {
        FieldElement res = new FieldElement(p);
        res.value = BigInteger.valueOf(1L);
        return res;
    }

    private FieldElement(BigInteger p) {
        this.p = p;
    }

    public FieldElement(BigInteger val, BigInteger p) {
        this.p = p;
        this.value = val;
        this.value.mod(p);
    }

    public FieldElement(int val, BigInteger p) {
        this.p = p;
        this.value = BigInteger.valueOf(val);
    }

    public FieldElement(FieldElement e) {
        this.p = e.p;
        this.value = e.value;
    }

    public FieldElement(OctetString fe, BigInteger p) {
        this(fe.value, p);
    }

    public FieldElement(byte[] serialization, BigInteger p) {
        this.value = new BigInteger(1, serialization).mod(p);
        this.p = p;
    }

    public BigInteger getp() {
        return this.p;
    }

    public BigInteger toBigInteger() {
        return this.value;
    }

    public boolean equals(FieldElement e) {
        return this.value.equals(e.value);
    }

    public boolean isZero() {
        return this.value.equals(BigInteger.valueOf(0L));
    }

    public void add(FieldElement b) {
        this.value = this.value.add(b.value).mod(this.p);
    }

    public static FieldElement add(FieldElement a, FieldElement b) {
        FieldElement res = new FieldElement(a);
        res.add(b);
        return res;
    }

    public void subtract(FieldElement b) {
        this.value = this.value.subtract(b.value).mod(this.p);
    }

    public static FieldElement subtract(FieldElement a, FieldElement b) {
        FieldElement res = new FieldElement(a);
        res.subtract(b);
        return res;
    }

    public void multiply(FieldElement a) {
        this.value = this.value.multiply(a.value).mod(this.p);
    }

    public void multiply(int a) {
        this.value = this.value.multiply(BigInteger.valueOf(a)).mod(this.p);
    }

    public static FieldElement multiply(FieldElement a, FieldElement b) {
        FieldElement res = new FieldElement(a);
        res.multiply(b);
        return res;
    }

    public static FieldElement exp(FieldElement f, BigInteger exponent) {
        FieldElement res = new FieldElement(f);
        res.exp(exponent);
        return res;
    }

    public void exp(BigInteger exponent) {
        this.value = this.value.modPow(exponent, this.p);
    }

    public static FieldElement inverse(FieldElement f) {
        FieldElement res = new FieldElement(f);
        res.inverse();
        return res;
    }

    public void inverse() {
        this.value = this.value.modInverse(this.p);
    }

    public byte[] toByteArray() {
        return this.value.mod(this.p).toByteArray();
    }

    public String toString() {
        return this.value.toString(16);
    }
}

