/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gfp;

import com.cryptomathic.ecc.gfp.Curve;
import com.cryptomathic.ecc.gfp.FieldElement;
import com.cryptomathic.ecc.gfp.Point;
import com.cryptomathic.ecc.gfp.PointElement;

public class JacobianPoint {
    FieldElement x;
    FieldElement y;
    FieldElement z;
    Curve C;

    public JacobianPoint(Point P) {
        this.C = (Curve)P.getCurve();
        if (P.isInfinity()) {
            this.z = FieldElement.Zero(this.C.getp());
            return;
        }
        this.x = P.getx();
        this.y = P.gety();
        this.z = FieldElement.One(this.C.getp());
    }

    public Point toPoint() {
        if (this.z.isZero()) {
            return Point.Infinity(this.C);
        }
        FieldElement zinv = FieldElement.inverse(this.z);
        FieldElement Px = FieldElement.multiply(zinv, zinv);
        FieldElement Py = FieldElement.multiply(Px, zinv);
        Px.multiply(this.x);
        Py.multiply(this.y);
        return new Point(Px, Py, this.C);
    }

    public void doublePoint() {
        if (this.z.isZero()) {
            return;
        }
        FieldElement ysq = FieldElement.multiply(this.y, this.y);
        FieldElement az4 = FieldElement.multiply(this.z, this.z);
        az4.multiply(az4);
        az4.multiply(this.C.geta());
        FieldElement l1 = FieldElement.multiply(this.x, this.x);
        l1.multiply(3);
        l1.add(az4);
        FieldElement l2 = FieldElement.multiply(this.x, ysq);
        l2.multiply(4);
        FieldElement l3 = FieldElement.multiply(ysq, ysq);
        l3.multiply(8);
        this.x = new FieldElement(l2);
        this.x.multiply(-2);
        this.x.add(FieldElement.multiply(l1, l1));
        this.z.multiply(this.y);
        this.z.multiply(2);
        this.y = FieldElement.subtract(l2, this.x);
        this.y.multiply(l1);
        this.y.subtract(l3);
    }

    public void sub_affine(PointElement P) {
        this.add_affine(new PointElement(P.x, FieldElement.subtract(FieldElement.Zero(P.x.getp()), P.y)));
    }

    public void add_affine(PointElement P) {
        if (P.isInfinity(this.C)) {
            return;
        }
        if (this.z.isZero()) {
            this.x = new FieldElement(P.x);
            this.y = new FieldElement(P.y);
            this.z = FieldElement.One(this.C.getp());
            return;
        }
        FieldElement zsq = FieldElement.multiply(this.z, this.z);
        FieldElement a = FieldElement.multiply(P.x, zsq);
        FieldElement b = FieldElement.multiply(P.y, zsq);
        b.multiply(this.z);
        FieldElement c = FieldElement.subtract(a, this.x);
        FieldElement d = FieldElement.subtract(b, this.y);
        FieldElement c3 = FieldElement.multiply(c, c);
        FieldElement xcsq = FieldElement.multiply(this.x, c3);
        c3.multiply(c);
        FieldElement newx = new FieldElement(xcsq);
        newx.multiply(-2);
        newx.subtract(c3);
        newx.add(FieldElement.multiply(d, d));
        this.y.multiply(c3);
        this.y.multiply(-1);
        this.y.add(FieldElement.multiply(d, FieldElement.subtract(xcsq, newx)));
        this.z.multiply(c);
        this.x = newx;
    }
}

