/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gfp;

import com.cryptomathic.ecc.gfp.Curve;
import com.cryptomathic.ecc.gfp.FieldElement;
import com.cryptomathic.ecc.gfp.JacobianPoint;
import com.cryptomathic.ecc.gfp.JacobianPoint_NIST;
import com.cryptomathic.ecc.gfp.PointElement;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;
import java.util.Vector;

public class Point
extends com.cryptomathic.ecc.Point {
    Curve C;
    PointElement P;

    public Point(byte[] serialization, Curve C) {
        this.P = new PointElement(serialization, C.p);
        this.C = C;
    }

    public Point(FieldElement x, FieldElement y, Curve C) {
        this.P = new PointElement(x, y);
        this.C = C;
    }

    public Point(PointElement P, Curve C) {
        this.P = P;
        this.C = C;
    }

    public Point(Point P) {
        this.P = P.P;
        this.C = P.C;
    }

    public PointElement getPointElement() {
        return this.P;
    }

    public static Point Infinity(Curve C) {
        if (!C.b.isZero()) {
            return new Point(FieldElement.Zero(C.p), FieldElement.Zero(C.p), C);
        }
        return new Point(FieldElement.Zero(C.p), FieldElement.One(C.p), C);
    }

    public static Point scalarMultiply(PointElement P, BigInteger a, Curve C) {
        return Point.scalarMultiply(new Point(P, C), a);
    }

    public com.cryptomathic.ecc.Point scalarMultiply(BigInteger a) {
        return Point.scalarMultiply(this, a);
    }

    public static Point scalarMultiply(Point P, BigInteger a) {
        if (P.P.width != 0 || P.equals(P.C.getG())) {
            int w = 4;
            if (P.C.getOrder().bitLength() > 300) {
                w = 5;
            }
            if (P.P.width != 0) {
                w = P.P.width;
            }
            return P.scalarMultiply_fixed_comb(a, w);
        }
        int w = 5;
        if (P.C.getOrder().bitLength() > 450) {
            w = 6;
        }
        return P.scalarMultiplyNAFw(a, w);
    }

    public Point scalarMultiplyaffine(BigInteger a) {
        return Point.scalarMultiplyaffine(this, a);
    }

    public static Point scalarMultiplyaffine(Point P, BigInteger a) {
        Point res = Point.Infinity(P.C);
        Point intermed = new Point(P);
        for (int i = 0; i < a.bitLength(); ++i) {
            if (a.testBit(i)) {
                res = Point.add(res, intermed);
            }
            intermed = Point.add(intermed, intermed);
        }
        return res;
    }

    private static Vector NAFw(BigInteger k, int w) {
        Vector<Integer> res = new Vector<Integer>(k.bitLength());
        BigInteger kcopy = new BigInteger(k.toByteArray());
        BigInteger big2 = new BigInteger("2");
        BigInteger big2poww = big2.pow(w);
        int twopoww = 1 << w;
        int twopowwminus1 = 1 << w - 1;
        while (kcopy.compareTo(BigInteger.ONE) >= 0) {
            if (kcopy.testBit(0)) {
                int kmods2w = kcopy.mod(big2poww).intValue();
                if (kmods2w > twopowwminus1) {
                    kmods2w -= twopoww;
                }
                kcopy = kcopy.subtract(BigInteger.valueOf(kmods2w));
                res.addElement(new Integer(kmods2w));
            } else {
                res.addElement(new Integer(0));
            }
            kcopy = kcopy.divide(big2);
        }
        return res;
    }

    private static Vector precomputePoints(Point P, int w) {
        Vector<PointElement> res = new Vector<PointElement>(1 << w - 2);
        Point twoP = Point.add(P, P);
        Point tempP = P;
        res.addElement(new PointElement(P.getPointElement()));
        for (int i = 3; i < 1 << w - 1; i += 2) {
            tempP = Point.add(twoP, tempP);
            res.addElement(new PointElement(tempP.getPointElement()));
        }
        return res;
    }

    public Point scalarMultiplyNAFw(BigInteger a, int w) {
        JacobianPoint Q = this.C.geta().equals(new FieldElement(-3, this.C.getp())) ? new JacobianPoint_NIST(Point.Infinity(this.C)) : new JacobianPoint(Point.Infinity(this.C));
        Vector precomppoints = Point.precomputePoints(this, w);
        Vector naf = Point.NAFw(a, w);
        for (int i = naf.size() - 1; i >= 0; --i) {
            Q.doublePoint();
            int ki = (Integer)naf.elementAt(i);
            if (ki > 0) {
                Q.add_affine((PointElement)precomppoints.elementAt(ki / 2));
            }
            if (ki >= 0) continue;
            Q.sub_affine((PointElement)precomppoints.elementAt(-ki / 2));
        }
        return Q.toPoint();
    }

    private synchronized boolean isPrecomputed_fixed_comb() {
        return this.P.width != 0;
    }

    private synchronized void invalidate() {
        this.P.width = 0;
    }

    private synchronized void precompute_fixed_comb(int w, int d) {
        if (this.P.width == w) {
            return;
        }
        this.P.fixed_comb_multiplas = new Vector(1 << w + 1);
        this.P.fixed_comb_multiplas.addElement(Point.Infinity(this.C).getPointElement());
        this.P.fixed_comb_multiplas.addElement(new PointElement(this.P));
        BigInteger dpow = BigInteger.valueOf(2L).pow(d);
        for (int i = 0; i < w - 1; ++i) {
            Point tempP = new Point((PointElement)this.P.fixed_comb_multiplas.elementAt(1 << i), this.C);
            tempP = tempP.scalarMultiplyaffine(dpow);
            this.P.fixed_comb_multiplas.addElement(new PointElement(tempP.getPointElement()));
            for (int j = 1; j < 1 << i + 1; ++j) {
                this.P.fixed_comb_multiplas.addElement(Point.add(tempP, new Point((PointElement)this.P.fixed_comb_multiplas.elementAt(j), this.C)).getPointElement());
            }
        }
        BigInteger epow = BigInteger.valueOf(2L).pow((d + 1) / 2);
        this.P.fixed_comb_multiplas.addElement(Point.Infinity(this.C).getPointElement());
        for (int i = 0; i < w; ++i) {
            Point tempP = new Point((PointElement)this.P.fixed_comb_multiplas.elementAt(1 << i), this.C);
            tempP = tempP.scalarMultiplyaffine(epow);
            this.P.fixed_comb_multiplas.addElement(new PointElement(tempP.getPointElement()));
            for (int j = (1 << w) + 1; j < (1 << w) + (1 << i); ++j) {
                this.P.fixed_comb_multiplas.addElement(Point.add(tempP, new Point((PointElement)this.P.fixed_comb_multiplas.elementAt(j), this.C)).getPointElement());
            }
        }
        this.P.width = w;
    }

    static int calcindex(BigInteger a, int i, int d, int w) {
        int k = 0;
        if (i >= d) {
            return k;
        }
        for (int j = w - 1; j >= 0; --j) {
            k *= 2;
            k += a.testBit(i + j * d) ? 1 : 0;
        }
        return k;
    }

    public synchronized Point scalarMultiply_fixed_comb(BigInteger a, int width) {
        int d = (this.C.getOrder().bitLength() + width - 1) / width;
        this.precompute_fixed_comb(width, d);
        JacobianPoint Q = this.C.geta().equals(new FieldElement(-3, this.C.getp())) ? new JacobianPoint_NIST(Point.Infinity(this.C)) : new JacobianPoint(Point.Infinity(this.C));
        for (int i = (d + 1) / 2 - 1; i >= 0; --i) {
            Q.doublePoint();
            int index = Point.calcindex(a, i, d, width);
            Q.add_affine((PointElement)this.P.fixed_comb_multiplas.elementAt(index));
            index = Point.calcindex(a, i + (d + 1) / 2, d, width);
            Q.add_affine((PointElement)this.P.fixed_comb_multiplas.elementAt(index + (1 << width)));
        }
        return Q.toPoint();
    }

    public boolean isOnCurve() {
        return this.P.isOnCurve(this.C);
    }

    public FieldElement gety() {
        return this.P.y;
    }

    public FieldElement getx() {
        return this.P.x;
    }

    public static FieldElement addXCoords(Point P, Point Q) {
        FieldElement l;
        if (P.isInfinity()) {
            return new FieldElement(Q.getx());
        }
        if (Q.isInfinity()) {
            return new FieldElement(P.getx());
        }
        if (!P.getx().equals(Q.getx())) {
            l = FieldElement.inverse(FieldElement.subtract(P.getx(), Q.getx()));
            l.multiply(FieldElement.subtract(P.gety(), Q.gety()));
        } else {
            if (!P.gety().equals(Q.gety()) || P.gety().isZero()) {
                return FieldElement.Zero(P.C.p);
            }
            l = FieldElement.multiply(Q.getx(), Q.getx());
            l.multiply(new FieldElement(3, P.C.p));
            l.add(P.C.a);
            l.multiply(FieldElement.inverse(FieldElement.multiply(new FieldElement(2, P.C.p), Q.gety())));
        }
        FieldElement x3 = FieldElement.multiply(l, l);
        x3.subtract(P.getx());
        x3.subtract(Q.getx());
        return x3;
    }

    public boolean isInfinity() {
        return this.equals(Point.Infinity(this.C));
    }

    public static Point add(Point R, Point Q) {
        FieldElement l;
        if (R.isInfinity()) {
            return new Point(Q);
        }
        if (Q.isInfinity()) {
            return new Point(R);
        }
        if (!R.P.x.equals(Q.P.x)) {
            l = FieldElement.inverse(FieldElement.subtract(R.P.x, Q.P.x));
            l.multiply(FieldElement.subtract(R.P.y, Q.P.y));
        } else {
            if (!R.P.y.equals(Q.P.y)) {
                return Point.Infinity(R.C);
            }
            if (R.P.y.isZero()) {
                return Point.Infinity(R.C);
            }
            l = FieldElement.multiply(Q.P.x, Q.P.x);
            l.multiply(new FieldElement(3, R.C.p));
            l.add(R.C.a);
            l.multiply(FieldElement.inverse(FieldElement.multiply(new FieldElement(2, R.C.p), Q.P.y)));
        }
        FieldElement x3 = FieldElement.multiply(l, l);
        x3.subtract(R.P.x);
        x3.subtract(Q.P.x);
        FieldElement y3 = FieldElement.subtract(Q.P.x, x3);
        y3.multiply(l);
        y3.subtract(Q.P.y);
        return new Point(x3, y3, R.C);
    }

    public BigInteger xtoBigInteger() {
        return this.P.x.toBigInteger();
    }

    public BigInteger addXCoordstoBigInteger(com.cryptomathic.ecc.Point T) {
        return Point.addXCoords(this, (Point)T).toBigInteger();
    }

    public com.cryptomathic.ecc.Curve getCurve() {
        return this.C;
    }

    public boolean equals(com.cryptomathic.ecc.Point Q) {
        return this.P.equals(((Point)Q).P);
    }

    public String toString() {
        return this.getx().toString() + "," + this.gety().toString();
    }

    public byte[] xToByteArray() {
        byte[] temp = ByteArray.toByteArray(this.P.x.toString());
        ByteArray res = new ByteArray(new byte[(this.C.getp().bitLength() + 7) / 8 - temp.length]);
        res.append(temp);
        return res.toByteArray();
    }

    public byte[] toByteArray() {
        return this.P.toByteArray(this.C.getp());
    }
}

