/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary;

import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandler3;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandler4;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.common.SignatureResult;
import com.cryptomathic.luxtrust.signinglibrary.general.Settings;
import com.cryptomathic.luxtrust.signinglibrary.general.VersionWebServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CSSignatureHandler
implements CSSignatureHandlerInterface {
    protected static final byte[] OID_MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    protected static final byte[] OID_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    protected static final byte[] OID_SHA256 = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    protected CSSignatureHandlerInterface signatureI = null;
    protected Boolean useSigner4 = false;
    protected Settings settings = null;
    protected static final String SIGNER3_SETTINGS_FILENAME = "/settings.properties";
    protected static final String SIGNER4_SETTINGS_FILENAME = "/settings.signer4.properties";
    protected static final String SIGNER_VERSION_SELECTOR_FILENAME = "/settings.signer.selector.properties";

    public CSSignatureHandler() {
        try {
            boolean bl = this.determineSignerVersion();
            if (bl) {
                this.instantiateInterface();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean determineSignerVersion() throws IOException {
        InputStream inputStream = null;
        String string = null;
        InputStream inputStream2 = this.getClass().getResourceAsStream(SIGNER_VERSION_SELECTOR_FILENAME);
        if (inputStream2 == null) {
            return false;
        }
        Properties properties = new Properties();
        properties.load(inputStream2);
        string = properties.getProperty("signer.versionUrl", "http://localhost/SignerVersionWebService/");
        if (string == null || string == "") {
            return false;
        }
        inputStream2.close();
        String string2 = VersionWebServiceUtil.getVersionFromWebService(string);
        if (string2 == null || string2 == "") {
            return false;
        }
        this.useSigner4 = VersionWebServiceUtil.useSigner4(string2);
        inputStream = this.useSigner4 == false ? this.getClass().getResourceAsStream(SIGNER3_SETTINGS_FILENAME) : this.getClass().getResourceAsStream(SIGNER4_SETTINGS_FILENAME);
        if (inputStream == null) {
            return false;
        }
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        inputStream.close();
        this.settings = new Settings(properties2, this.useSigner4);
        return true;
    }

    protected void instantiateInterface() {
        this.signatureI = this.useSigner4 != false ? new CSSignatureHandler4(this.settings) : new CSSignatureHandler3(this.settings);
    }

    public String getVersion() {
        if (this.signatureI == null) {
            return "N/A";
        }
        return this.signatureI.getVersion();
    }

    public Result logIn(CSSignatureHandlerInterface.AuthenticationType authenticationType, String string, String string2) {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.logIn(authenticationType, string, string2);
    }

    public Result logOut() {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.logOut();
    }

    public Result initialiseSigning() {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.initialiseSigning();
    }

    public SignatureResult createAuthenticationSignature(String string, byte[] byArray, boolean bl) {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.createAuthenticationSignature(string, byArray, bl);
    }

    public SignatureResult createSignature(String string, byte[] byArray, boolean bl) {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.createSignature(string, byArray, bl);
    }

    public Result initialise() {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.initialise();
    }

    public Result terminate() {
        if (this.signatureI == null) {
            return new SignatureResult(ResultCodes.ERROR_LIBRARY_NOT_INITIALISED, "Library is not successfully initialised.");
        }
        return this.signatureI.terminate();
    }
}

