/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary;

import com.cryptomathic.luxtrust.Version;
import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.common.SignatureResult;
import com.cryptomathic.luxtrust.signinglibrary.general.Settings;
import com.cryptomathic.luxtrust.signinglibrary.general.SignerSignatureJob;
import com.cryptomathic.ss.customer.BadPasswordException;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.ProtectionException;
import com.cryptomathic.ss.customer.ServletInputOutputStream;
import com.cryptomathic.ss.customer.SignerCommandLayer;
import com.cryptomathic.ss.customer.SignerKeyPair;
import java.io.IOException;
import java.net.MalformedURLException;

public class CSSignatureHandler3
implements CSSignatureHandlerInterface {
    private static final int AUTHENTICATION_TOTP = 32;
    private static final int AUTHENTICATION_VASCO = 256;
    private static final int AUTHENTICATION_SMS = 16;
    private Settings settings;
    private transient String username;
    private transient String password;
    protected transient SignerKeyPair key_pair;
    private CSSignatureHandlerInterface.AuthenticationType authentication_spec;
    private int protspec;
    private boolean connection = false;
    private SignerSignatureJob current_job = null;
    private String last_error = "";
    private byte[] last_p7signature = new byte[0];

    public CSSignatureHandler3(Settings settings) {
        this.settings = settings;
    }

    public String getVersion() {
        return Version.getFullVersion();
    }

    private boolean verifyLogon() {
        return this.username != null;
    }

    /*
     * Exception decompiling
     */
    public Result logIn(CSSignatureHandlerInterface.AuthenticationType var1_1, String var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Result logOut() {
        if (!this.connection) {
            this.last_error = "Signer connection not initialised.";
            return new SignatureResult(ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED, this.last_error);
        }
        if (!this.verifyLogon()) {
            this.last_error = "User not logged in.";
            return new Result(ResultCodes.ERROR_NOT_LOGGED_IN, "Not logged on");
        }
        this.username = null;
        this.password = null;
        this.key_pair = null;
        this.authentication_spec = null;
        return new Result(ResultCodes.OK, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result initialiseSigning() {
        SignerSignatureJob signerSignatureJob;
        if (!this.connection) {
            this.last_error = "Signer connection not initialised.";
            return new SignatureResult(ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED, this.last_error);
        }
        if (!this.verifyLogon()) {
            this.last_error = "User not logged in.";
            return new Result(ResultCodes.ERROR_NOT_LOGGED_IN, "Not logged on");
        }
        if (this.current_job != null) {
            this.last_error = "Signing already in progress";
            return new Result(ResultCodes.ERROR_SIGNING_IN_PROGRESS, "Signing already in progress");
        }
        SignerCommandLayer signerCommandLayer = SignerCommandLayer.getInstance();
        try {
            signerCommandLayer.initialise(new ServletInputOutputStream(this.settings.getSignerURL()));
            signerCommandLayer.logOn(this.username, this.password, this.protspec);
            signerCommandLayer.getChallenge();
        }
        catch (MalformedURLException malformedURLException) {
            this.last_error = "Could not parse the Signer URL: " + this.settings.getSignerURL();
            return new Result(ResultCodes.ERROR_INVALID_URL, this.last_error);
        }
        catch (BadPasswordException badPasswordException) {
            this.last_error = "SMS notification failed";
            return new Result(ResultCodes.ERROR_SMS_NOTIFICATION_FAILED, this.last_error);
        }
        catch (CustCommException custCommException) {
            this.last_error = "Communication with server failed: " + custCommException.getMessage() + " URL = " + this.settings.getSignerURL();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (IOException iOException) {
            this.last_error = "Communication with server failed: " + iOException.getMessage() + " URL = " + this.settings.getSignerURL();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        byte[] byArray = new byte[]{};
        this.current_job = signerSignatureJob = new SignerSignatureJob("", byArray, this.protspec, signerCommandLayer, "");
        return new Result(ResultCodes.OK, "");
    }

    /*
     * Exception decompiling
     */
    protected SignatureResult createSignatureInternal(String var1_1, byte[] var2_2, boolean var3_3, boolean var4_4, boolean var5_5, String var6_6, String var7_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 55[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SignatureResult createAuthenticationSignature(String string, byte[] byArray, boolean bl) {
        return this.createSignatureInternal(string, byArray, false, true, bl, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1.toString(), AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7.toString());
    }

    public SignatureResult createSignature(String string, byte[] byArray, boolean bl) {
        return this.createSignatureInternal(string, byArray, false, false, bl, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1.toString(), AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7.toString());
    }

    public Result initialise() {
        return this.ping();
    }

    public Result terminate() {
        return new Result(ResultCodes.OK);
    }

    private Result ping() {
        this.connection = false;
        try {
            SignerCommandLayer signerCommandLayer = SignerCommandLayer.getInstance();
            signerCommandLayer.initialise(new ServletInputOutputStream(this.settings.getSignerURL()));
            signerCommandLayer.pingAnonymous();
        }
        catch (CustCommException custCommException) {
            return new Result(ResultCodes.ERROR_CONNECTION, "Could not initialise connection to CS. URL: " + this.settings.getSignerURL() + "  " + custCommException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            return new Result(ResultCodes.ERROR_INVALID_URL, "Could not initialise connection to CS. Invalid URL: " + this.settings.getSignerURL() + "  " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            return new Result(ResultCodes.ERROR_CONNECTION, "Could not initialise connection to CS. URL: " + this.settings.getSignerURL() + "  " + iOException.getMessage());
        }
        catch (ProtectionException protectionException) {
            return new Result(ResultCodes.ERROR_CONNECTION, "Could not initialise connection to CS. URL: " + this.settings.getSignerURL() + "  " + protectionException.getMessage());
        }
        this.connection = true;
        return new Result(ResultCodes.OK, "URL: " + this.settings.getSignerURL());
    }

    private class InternalException
    extends Exception {
        private int errorcode;

        public InternalException(int n) {
            this.errorcode = n;
        }

        public int geterr() {
            return this.errorcode;
        }
    }
}

