/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary;

import com.cryptomathic.luxtrust.Version;
import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.common.SignatureResult;
import com.cryptomathic.luxtrust.signinglibrary.general.Hex;
import com.cryptomathic.luxtrust.signinglibrary.general.Settings;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.api.user.PolicyEntry;
import com.cryptomathic.signer.sdk.user.SignerUserConnection;
import com.cryptomathic.signer.sdk.user.SignerUserException;
import com.cryptomathic.signer.sdk.user.crypto.ClientSrp;
import com.cryptomathic.signer.sdk.user.crypto.DecryptFailedException;
import com.cryptomathic.signer.sdk.user.utils.AuthenticationToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.List;

public class CSSignatureHandler4
implements CSSignatureHandlerInterface {
    protected Settings settings;
    protected boolean connection = false;
    protected byte[] serverG;
    protected byte[] serverN;
    protected transient String userName;
    protected transient String userPassword;
    protected CSSignatureHandlerInterface.AuthenticationType userAuth;
    protected AuthenticationToken userToken = null;
    protected KeyEntry userSigningKey = null;
    protected boolean hasJob = false;
    protected SignerUserConnection jobConnection = null;
    protected String last_error = "";
    protected byte[] last_p1signature = new byte[0];
    protected byte[] last_p7signature = new byte[0];

    public CSSignatureHandler4(Settings settings) {
        this.settings = settings;
    }

    public String getVersion() {
        return Version.getFullVersion();
    }

    protected boolean verifyLogon() {
        return this.userName != null;
    }

    protected Result logInAndCheckAuth(SignerUserConnection signerUserConnection, String string, String string2) {
        try {
            SignerUserConnection.LoginStatus loginStatus = signerUserConnection.logon(string, string2);
            signerUserConnection.noop();
            switch (loginStatus) {
                case LOGGED_IN_AND_READY: {
                    break;
                }
                case LOGGED_IN_MUST_CHANGE_PASSWORD: {
                    this.last_error = "Password must be renewed";
                    return new Result(ResultCodes.ERROR_PASSWORD_MUST_BE_RENEWED, this.last_error);
                }
                case LOGGED_IN_WITH_INITIAL_PASSWORD: {
                    this.last_error = "Password must be renewed";
                    return new Result(ResultCodes.ERROR_PASSWORD_MUST_BE_RENEWED, this.last_error);
                }
                default: {
                    this.last_error = "Authentication failed";
                    return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.last_error = "Failed to communicate with Signer server: " + unknownHostException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (IOException iOException) {
            this.last_error = "Failed to communicate with Signer server: " + iOException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (SignerUserException signerUserException) {
            switch (signerUserException.getErrorCode()) {
                case USER_DISABLED: 
                case USER_SUSPENDED: {
                    this.last_error = "Authentication failed: " + signerUserException.getMessage();
                    return new Result(ResultCodes.ERROR_USER_SUSPENDED, this.last_error);
                }
                case USER_MUST_CHANGE_PASSWORD: 
                case USER_MUST_ACTIVATE_ACCOUNT: {
                    this.last_error = "Password must be renewed: " + signerUserException.getMessage();
                    return new Result(ResultCodes.ERROR_PASSWORD_MUST_BE_RENEWED, this.last_error);
                }
            }
            this.last_error = "Authentication failed: " + signerUserException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        catch (ClientSrp.SrpException srpException) {
            this.last_error = "Authentication failed: " + srpException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        catch (DecryptFailedException decryptFailedException) {
            this.last_error = "Authentication failed: " + decryptFailedException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        return new Result(ResultCodes.OK, "");
    }

    public Result logIn(CSSignatureHandlerInterface.AuthenticationType authenticationType, String string, String string2) {
        if (!this.connection) {
            this.last_error = "Signer connection not initialised.";
            return new SignatureResult(ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED, this.last_error);
        }
        if (this.verifyLogon()) {
            this.logOut();
        }
        if (string == null || string.length() == 0) {
            this.last_error = "Username is null";
            return new Result(ResultCodes.ERROR_BAD_PARAMETER, "Username is null");
        }
        if (string2 == null || string2.length() == 0) {
            this.last_error = "Password is null";
            return new Result(ResultCodes.ERROR_BAD_PARAMETER, "Password is null");
        }
        if (authenticationType != CSSignatureHandlerInterface.AuthenticationType.SMS && authenticationType != CSSignatureHandlerInterface.AuthenticationType.VASCO && authenticationType != CSSignatureHandlerInterface.AuthenticationType.TOTP) {
            this.last_error = "Unknown authentication type: " + (Object)((Object)this.userAuth);
            return new Result(ResultCodes.ERROR_BAD_PARAMETER, "Unknown authentication type: " + (Object)((Object)this.userAuth));
        }
        byte[] byArray = Hex.decode(this.settings.getSRP_g());
        byte[] byArray2 = Hex.decode(this.settings.getSRP_N());
        SignerUserConnection signerUserConnection = null;
        try {
            signerUserConnection = new SignerUserConnection(this.settings.getSignerURL(), byArray2, byArray);
        }
        catch (MalformedURLException malformedURLException) {
            this.last_error = "Could not initialise connection to Signer. URL: " + this.settings.getSignerURL() + "  " + malformedURLException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        Result result = this.logInAndCheckAuth(signerUserConnection, string, string2);
        if (result.getResultCode() != ResultCodes.OK) {
            return result;
        }
        try {
            KeyEntry keyEntry = this.findSigningKeyPair(signerUserConnection);
            String string3 = null;
            switch (authenticationType) {
                case VASCO: {
                    string3 = "Vasco-OTP-Time";
                    break;
                }
                case SMS: {
                    string3 = "SMS";
                    break;
                }
                case TOTP: {
                    string3 = "OATH-TOTP";
                    break;
                }
                default: {
                    return new Result(ResultCodes.ERROR_BAD_PARAMETER, "Invalid Authentication spec");
                }
            }
            int n = -1;
            List<AuthenticationToken> list = signerUserConnection.getTokens();
            for (int i = 0; i < list.size(); ++i) {
                AuthenticationToken authenticationToken = list.get(i);
                if (!authenticationToken.getTokenType().equalsIgnoreCase(string3)) continue;
                n = n == -2 ? -2 : (n == -1 ? i : -2);
            }
            if (n < 0) {
                this.last_error = "Unable to find a unique token.";
                return new Result(ResultCodes.ERROR_NO_CERTIFICATE_FOUND, this.last_error);
            }
            this.userToken = list.get(n);
            this.userSigningKey = keyEntry;
        }
        catch (UnknownHostException unknownHostException) {
            this.last_error = "Failed to communicate with server: " + unknownHostException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (IOException iOException) {
            this.last_error = "Failed to communicate with server: " + iOException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (SignerUserException signerUserException) {
            this.last_error = "Authentication failed: " + signerUserException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        catch (DecryptFailedException decryptFailedException) {
            this.last_error = "Authentication failed: " + decryptFailedException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        catch (InternalException internalException) {
            return new Result(internalException.getRC(), internalException.getDescription());
        }
        this.userName = string;
        this.userPassword = string2;
        this.userAuth = authenticationType;
        this.serverG = byArray;
        this.serverN = byArray2;
        signerUserConnection.logoff();
        return new Result(ResultCodes.OK, "");
    }

    public Result logOut() {
        if (!this.connection) {
            this.last_error = "Signer connection not initialised.";
            return new SignatureResult(ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED, this.last_error);
        }
        if (!this.verifyLogon()) {
            this.last_error = "User not logged in.";
            return new Result(ResultCodes.ERROR_NOT_LOGGED_IN, "Not logged on");
        }
        this.userName = null;
        this.userPassword = null;
        this.userAuth = null;
        this.serverG = null;
        this.serverN = null;
        this.jobConnection = null;
        this.userToken = null;
        this.userSigningKey = null;
        return new Result(ResultCodes.OK, "");
    }

    public Result initialiseSigning() {
        Object object;
        SignerUserConnection signerUserConnection;
        block13: {
            if (!this.connection) {
                this.last_error = "Signer connection not initialised.";
                return new SignatureResult(ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED, this.last_error);
            }
            if (!this.verifyLogon()) {
                this.last_error = "User not logged in.";
                return new Result(ResultCodes.ERROR_NOT_LOGGED_IN, this.last_error);
            }
            if (this.hasJob) {
                this.last_error = "Signing already in progress.";
                return new Result(ResultCodes.ERROR_SIGNING_IN_PROGRESS, this.last_error);
            }
            try {
                int n;
                int n2;
                signerUserConnection = new SignerUserConnection(this.settings.getSignerURL(), this.serverN, this.serverG);
                if (this.userAuth != CSSignatureHandlerInterface.AuthenticationType.TOTP) break block13;
                object = this.getClass().getResourceAsStream("/authenticator.ctk.bin");
                int n3 = 0;
                byte[] byArray = new byte[n2];
                for (n2 = 1024; n2 > 0; n2 -= n) {
                    n = 0;
                    try {
                        n = ((InputStream)object).read(byArray, n3, n2);
                    }
                    catch (IOException iOException) {
                        this.last_error = "Error reading file /authenticator.ctk.bin: " + iOException.getMessage();
                        return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
                    }
                    if (n < 1) break;
                    n3 += n;
                }
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                signerUserConnection.setCtk(byArray2);
            }
            catch (MalformedURLException malformedURLException) {
                this.last_error = "Could not initialise connection to Signer. URL: " + this.settings.getSignerURL() + "  " + malformedURLException.getMessage();
                return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
            }
        }
        object = this.logInAndCheckAuth(signerUserConnection, this.userName, this.userPassword);
        if (((Result)object).getResultCode() != ResultCodes.OK) {
            return object;
        }
        try {
            if (this.userAuth == CSSignatureHandlerInterface.AuthenticationType.SMS) {
                signerUserConnection.getChallenge(this.userToken);
            }
            this.hasJob = true;
            this.jobConnection = signerUserConnection;
        }
        catch (IOException iOException) {
            this.last_error = "Failed to communicate with server: " + iOException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (SignerUserException signerUserException) {
            this.last_error = "Authentication failed: " + signerUserException.getMessage();
            return new Result(ResultCodes.ERROR_INCORRECT_AUTHENTICATION, this.last_error);
        }
        return new Result(ResultCodes.OK, "");
    }

    protected KeyEntry findSigningKeyPair(SignerUserConnection signerUserConnection) throws InternalException, IOException, DecryptFailedException, SignerUserException {
        List<PolicyEntry> list = signerUserConnection.getPolicies();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            PolicyEntry policyEntry = list.get(i);
            if (!policyEntry.enabled || !policyEntry.canSign) continue;
            n = n == -2 ? -2 : (n == -1 ? i : -2);
        }
        if (n < 0) {
            this.last_error = "Unable to find active policy for signing.";
            if (n == -1) {
                throw new InternalException(ResultCodes.ERROR_NO_CERTIFICATE_FOUND, "Unable to find any active policy for signing.");
            }
            throw new InternalException(ResultCodes.ERROR_NO_CERTIFICATE_FOUND, "Unable to find unique active policy for signing.");
        }
        PolicyEntry policyEntry = list.get(n);
        n = -1;
        for (int i = 0; i < policyEntry.keys.size(); ++i) {
            KeyEntry keyEntry = policyEntry.keys.get(i);
            if (keyEntry.optionalExpiredDate != 0L) continue;
            n = n == -2 ? -2 : (n == -1 ? i : -2);
        }
        if (n < 0) {
            if (n == -1) {
                throw new InternalException(ResultCodes.ERROR_NO_CERTIFICATE_FOUND, "Unable to find any active key-pair on policy.");
            }
            throw new InternalException(ResultCodes.ERROR_NO_CERTIFICATE_FOUND, "Unable to find unique active key-pair on policy.");
        }
        return policyEntry.keys.get(n);
    }

    /*
     * Exception decompiling
     */
    protected SignatureResult createSignatureInternal(String var1_1, byte[] var2_2, boolean var3_3, boolean var4_4, String var5_5, String var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 60[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SignatureResult createAuthenticationSignature(String string, byte[] byArray, boolean bl) {
        return this.createSignatureInternal(string, byArray, false, bl, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1.toString(), AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7.toString());
    }

    public SignatureResult createSignature(String string, byte[] byArray, boolean bl) {
        return this.createSignatureInternal(string, byArray, false, bl, AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1.toString(), AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7.toString());
    }

    public Result initialise() {
        return this.ping();
    }

    public Result terminate() {
        return new Result(ResultCodes.OK);
    }

    private Result ping() {
        SignerUserConnection signerUserConnection;
        try {
            String string = this.settings.getSignerURL();
            byte[] byArray = Hex.decode(this.settings.getSRP_N());
            byte[] byArray2 = Hex.decode(this.settings.getSRP_g());
            signerUserConnection = new SignerUserConnection(string, byArray, byArray2);
        }
        catch (MalformedURLException malformedURLException) {
            this.last_error = "Could not initialise connection to Signer. URL: " + this.settings.getSignerURL() + "  " + malformedURLException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        try {
            signerUserConnection.connect();
            signerUserConnection.ping();
        }
        catch (IOException iOException) {
            this.last_error = "Failed to communicate with server: " + iOException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        catch (SignerUserException signerUserException) {
            this.last_error = "Failed to communicate with server: " + signerUserException.getMessage();
            return new Result(ResultCodes.ERROR_CONNECTION, this.last_error);
        }
        this.connection = true;
        return new Result(ResultCodes.OK, "URL: " + this.settings.getSignerURL());
    }

    protected class InternalException
    extends Exception {
        private ResultCodes resultCode;
        private String errorDesc;

        public InternalException(ResultCodes resultCodes, String string) {
            this.resultCode = resultCodes;
            this.errorDesc = string;
        }

        public String getDescription() {
            return this.errorDesc;
        }

        public ResultCodes getRC() {
            return this.resultCode;
        }
    }
}

