/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary.common;

import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;

public class SignatureResult
extends Result {
    private byte[] signature;

    SignatureResult(Result result) {
        this.resultCode = result.resultCode;
        this.errorDescription = result.errorDescription;
    }

    public SignatureResult(ResultCodes resultCodes, byte[] byArray) {
        this(resultCodes, "", byArray);
    }

    public SignatureResult(ResultCodes resultCodes, String string) {
        this(resultCodes, string, null);
    }

    public SignatureResult(ResultCodes resultCodes) {
        this(resultCodes, null, null);
    }

    SignatureResult(ResultCodes resultCodes, String string, byte[] byArray) {
        this.resultCode = resultCodes;
        this.signature = byArray;
        this.errorDescription = string;
    }

    private String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nHex-encoded Signature: ";
        string = string + (this.signature != null ? this.bytesToHexString(this.signature) : "<empty>");
        return string;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

