/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary.general;

import com.cryptomathic.luxtrust.signinglibrary.general.JNIInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class LibraryUtil {
    private static final int BUFFER_SIZE = 32768;
    private static final String DLL_HASH = "841a358bee9e5f6273d9cabba37f26b81d837e7d";
    private static final String SO_HASH = "61271170eaab45b88c6466bfaff4d1e6a566dbbb";

    private static String bytesToHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string;
    }

    public static JNIInterface loadLibrary(Class clazz, String string, String string2) throws IOException {
        String string3 = LibraryUtil.unpackLibrary(clazz, string, string2);
        Runtime.getRuntime().load(string3);
        return new JNIInterface();
    }

    public static String unpackLibrary(Class clazz, String string, String string2) throws IOException {
        byte[] byArray;
        Object object;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            System.err.println("Fatal: Did not find the DLL file: " + string);
            throw new IOException("Did not find the DLL file: " + string);
        }
        File file = File.createTempFile("interface", "." + string2);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            object = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = new byte[32768];
            while ((n = inputStream.read(byArray2)) != -1) {
                fileOutputStream.write(byArray2, 0, n);
                ((MessageDigest)object).update(byArray2, 0, n);
            }
            byArray = ((MessageDigest)object).digest();
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Failed to copy DLL to temporary file due to error: " + iOException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Failed to create hash of the DLL file: " + noSuchAlgorithmException.getMessage());
        }
        object = LibraryUtil.bytesToHexString(byArray);
        if (file.getName().toLowerCase().endsWith("so") && !SO_HASH.equalsIgnoreCase((String)object)) {
            throw new IOException("The SO file extracted from the jar file does not match the expected SO file");
        }
        if (file.getName().toLowerCase().endsWith("dll") && !DLL_HASH.equalsIgnoreCase((String)object)) {
            throw new IOException("The DLL file extracted from the jar file does not match the expected DLL file");
        }
        return file.getAbsolutePath();
    }
}

