/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary.general;

import java.util.Properties;

public class Settings {
    private int min_window_height;
    private int min_window_width;
    private String signer_url;
    private boolean encrypt_result;
    private boolean isSigner4;
    private String srp_g;
    private String srp_N;

    public Settings(Properties properties, boolean bl) {
        this.min_window_width = this.getIntSetting(properties, "window.width.min", 150);
        this.min_window_height = this.getIntSetting(properties, "window.height.min", 150);
        this.isSigner4 = bl;
        String string = !bl ? "http://signerforwarder:8080/Signer/forwarder" : "https://signer4forward/signer-forwarder/";
        this.signer_url = this.getStringSetting(properties, "signer.url", string);
        this.encrypt_result = this.getBoolSetting(properties, "signer.encryptresult", false);
        if (bl) {
            this.srp_g = this.getStringSetting(properties, "signer.SRP_g", "");
            this.srp_N = this.getStringSetting(properties, "signer.SRP_N", "");
        }
    }

    private int getIntSetting(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private String getStringSetting(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private boolean getBoolSetting(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if ((string2 = string2.trim()).compareToIgnoreCase("true") == 0 || string2.compareToIgnoreCase("yes") == 0) {
            return true;
        }
        if (string2.compareToIgnoreCase("false") == 0 || string2.compareToIgnoreCase("no") == 0) {
            return false;
        }
        return bl;
    }

    public int getMinWindowHeight() {
        return this.min_window_height;
    }

    public int getMinWindowWidth() {
        return this.min_window_width;
    }

    public String getSignerURL() {
        return this.signer_url;
    }

    public boolean encryptResult() {
        return this.encrypt_result;
    }

    public String getSRP_g() {
        return this.srp_g;
    }

    public String getSRP_N() {
        return this.srp_N;
    }

    public Boolean getUseSigner4() {
        return this.isSigner4;
    }
}

