/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security;

import com.cryptomathic.crypto.des.DesException;
import com.cryptomathic.crypto.des.DesMode;
import com.cryptomathic.crypto.des.DesState;
import com.cryptomathic.crypto.des.DesType;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.security.EKeyEncoding;
import com.cryptomathic.security.EPinException;
import com.cryptomathic.security.EncodingUtil;
import com.cryptomathic.security.RSAPrivateKey;
import java.math.BigInteger;

public class RSAPrivateCrtKey
extends RSAPrivateKey
implements java.security.interfaces.RSAPrivateCrtKey {
    private BigInteger _primeP;
    private BigInteger _primeQ;
    private BigInteger _exponentP;
    private BigInteger _exponentQ;
    private BigInteger _coefficientP;
    private BigInteger _coefficientQ;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);

    public RSAPrivateCrtKey() {
    }

    public RSAPrivateCrtKey(BigInteger P, BigInteger Q, BigInteger exponent) {
        super(P.multiply(Q), exponent);
        this._primeP = P;
        this._primeQ = Q;
        this._exponentP = exponent.mod(P.subtract(ONE));
        this._exponentQ = exponent.mod(Q.subtract(ONE));
        this._coefficientP = Q.multiply(Q.modPow(P.subtract(TWO), P));
        this._coefficientQ = P.multiply(P.modPow(Q.subtract(TWO), Q));
    }

    public RSAPrivateCrtKey(byte[] encoding) throws EKeyEncoding {
        super(encoding);
        int next = 2 + EncodingUtil.encodeSize(encoding, 0);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._primeP = EncodingUtil.decodeBI(encoding, next);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._primeQ = EncodingUtil.decodeBI(encoding, next);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._exponentP = EncodingUtil.decodeBI(encoding, next);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._exponentQ = EncodingUtil.decodeBI(encoding, next);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._coefficientP = EncodingUtil.decodeBI(encoding, next);
        next += 2 + EncodingUtil.encodeSize(encoding, next);
        this._coefficientQ = EncodingUtil.decodeBI(encoding, next);
    }

    public BigInteger exp(BigInteger x) {
        BigInteger xdp = x.modPow(this._exponentP, this.getPrimeP());
        BigInteger xdq = x.modPow(this._exponentQ, this.getPrimeQ());
        xdp = xdp.multiply(this._coefficientP);
        xdq = xdq.multiply(this._coefficientQ);
        return xdp.add(xdq).mod(this.getModulus());
    }

    public BigInteger getPublicExponent() {
        if (this.getPrivateExponent() == null) {
            throw new RuntimeException("Exponent not available");
        }
        BigInteger euler = this.getPrimeP().subtract(ONE).multiply(this.getPrimeQ().subtract(ONE));
        return this.getPrivateExponent().modInverse(euler);
    }

    public BigInteger getPrimeP() {
        return this._primeP;
    }

    public BigInteger getPrimeQ() {
        return this._primeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this._exponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this._exponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this._coefficientP;
    }

    public String getFormat() {
        return "Internal Cryptomathic Format";
    }

    public byte[] getEncoded() {
        byte[] superEnc = super.getEncoded();
        byte[] encP = EncodingUtil.encodeBI(this._primeP);
        byte[] encQ = EncodingUtil.encodeBI(this._primeQ);
        byte[] encEP = EncodingUtil.encodeBI(this._exponentP);
        byte[] encEQ = EncodingUtil.encodeBI(this._exponentQ);
        byte[] encCP = EncodingUtil.encodeBI(this._coefficientP);
        byte[] encCQ = EncodingUtil.encodeBI(this._coefficientQ);
        byte[] retVal = new byte[superEnc.length + encP.length + encQ.length + encEP.length + encEQ.length + encCP.length + encCQ.length];
        int length = 0;
        System.arraycopy(superEnc, 0, retVal, length, superEnc.length);
        System.arraycopy(encP, 0, retVal, length += superEnc.length, encP.length);
        System.arraycopy(encQ, 0, retVal, length += encP.length, encQ.length);
        System.arraycopy(encEP, 0, retVal, length += encQ.length, encEP.length);
        System.arraycopy(encEQ, 0, retVal, length += encEP.length, encEQ.length);
        System.arraycopy(encCP, 0, retVal, length += encEQ.length, encCP.length);
        System.arraycopy(encCQ, 0, retVal, length += encCP.length, encCQ.length);
        return retVal;
    }

    public String toString() {
        return "n: " + this.getModulus().toString() + "p: " + this._primeP.toString() + "q: " + this._primeQ.toString() + "ep: " + this._exponentP.toString() + "eq: " + this._exponentQ.toString() + "cp: " + this._coefficientP.toString() + "cq: " + this._coefficientQ.toString();
    }

    private static byte[] encrypt(byte[] key, byte[] pin) throws EPinException {
        int split = key.length / 8 * 8;
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] retVal = new byte[key.length];
        try {
            DesState state = DesState.des_start_mode(DesType.DES, DesMode.CBCE, pin, iv);
            state.des_do_mode(key, retVal, 0, split, 0);
            System.arraycopy(retVal, split - 8, iv, 0, 8);
            state = DesState.des_start_mode(DesType.DES, DesMode.CFBE, pin, iv);
            state.des_do_mode(key, retVal, split, key.length - split, split);
            state.des_stop_mode(PadMode.NOPAD, key, retVal, 0, 0, 0);
        }
        catch (DesException e) {
            throw new EPinException(e.toString());
        }
        return retVal;
    }

    private static byte[] decrypt(byte[] key, byte[] pin) throws EPinException {
        int split = key.length / 8 * 8;
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] retVal = new byte[key.length];
        try {
            DesState state = DesState.des_start_mode(DesType.DES, DesMode.CBCD, pin, iv);
            state.des_do_mode(key, retVal, 0, split, 0);
            System.arraycopy(key, split - 8, iv, 0, 8);
            state = DesState.des_start_mode(DesType.DES, DesMode.CFBD, pin, iv);
            state.des_do_mode(key, retVal, split, key.length - split, split);
            state.des_stop_mode(PadMode.NOPAD, key, retVal, 0, 0, 0);
        }
        catch (DesException e) {
            throw new EPinException(e.toString());
        }
        return retVal;
    }

    private static byte[] makeKey(byte[] pin) throws EPinException {
        byte[] tmp2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] tmp = pin.length % 8 != 0 ? new byte[(pin.length / 8 + 1) * 8] : new byte[pin.length];
        System.arraycopy(tmp2, 0, tmp, tmp.length - 8, 8);
        System.arraycopy(pin, 0, tmp, 0, pin.length);
        try {
            return HashMech.hash_mes(HashType.MDC2, HashPadMode.NOPAD, tmp, tmp.length);
        }
        catch (HashException e) {
            throw new EPinException(e.toString());
        }
    }

    private void addBigInteger(byte[] encoding, int index, BigInteger number, int max) {
        byte[] bendian = number.toByteArray();
        int i = 0;
        int start = 0;
        if (bendian[0] == 0) {
            start = 1;
        }
        for (i = start; i < bendian.length; ++i) {
            encoding[index + (i - start)] = bendian[bendian.length - 1 - (i - start)];
        }
        while (i < max) {
            encoding[index + i++] = 0;
        }
    }

    private BigInteger getBigInteger(byte[] encoding, int index, int length) {
        int start;
        byte[] bendian;
        if (encoding[index + length - 1] < 0) {
            bendian = new byte[length + 1];
            bendian[0] = 0;
            start = 1;
        } else {
            bendian = new byte[length];
            start = 0;
        }
        for (int i = 0; i < length; ++i) {
            bendian[start + i] = encoding[index + length - 1 - i];
        }
        return new BigInteger(bendian);
    }

    private static void addTail(byte[] encoding, int index) {
        for (int i = 0; i < 8; ++i) {
            encoding[index + i] = encoding[index - 8 + i];
        }
    }

    private byte[] encode() {
        int plength = (this._primeP.bitLength() + 7) / 8;
        int qlength = (this._primeQ.bitLength() + 7) / 8;
        int length = 6 + 3 * (plength + qlength) + 8;
        byte[] retVal = new byte[length];
        retVal[0] = (byte)(length & 0xFF);
        retVal[1] = (byte)(length / 256 & 0xFF);
        retVal[2] = (byte)(plength & 0xFF);
        retVal[3] = (byte)(plength / 256 & 0xFF);
        retVal[4] = (byte)(qlength & 0xFF);
        retVal[5] = (byte)(qlength / 256 & 0xFF);
        int index = 6;
        this.addBigInteger(retVal, index, this._primeP, plength);
        this.addBigInteger(retVal, index += plength, this._primeQ, qlength);
        this.addBigInteger(retVal, index += qlength, this._coefficientP.divide(this._primeQ), plength);
        this.addBigInteger(retVal, index += plength, this._coefficientQ.divide(this._primeP), qlength);
        this.addBigInteger(retVal, index += qlength, this._exponentP, plength);
        this.addBigInteger(retVal, index += plength, this._exponentQ, qlength);
        RSAPrivateCrtKey.addTail(retVal, index += qlength);
        return retVal;
    }

    static int bytesToInt(byte[] encoding, int index) {
        int temp;
        int retVal = encoding[index];
        if (retVal < 0) {
            retVal += 256;
        }
        if ((temp = encoding[index + 1]) < 0) {
            temp += 256;
        }
        return retVal += 256 * temp;
    }

    private BigInteger calcPrivateExponent(BigInteger P, BigInteger Q, BigInteger expP, BigInteger expQ) {
        BigInteger u1 = ONE;
        BigInteger u2 = ZERO;
        BigInteger v1 = ZERO;
        BigInteger v2 = ONE;
        BigInteger r = P.subtract(ONE).gcd(Q.subtract(ONE));
        BigInteger a = P.subtract(ONE).divide(r);
        BigInteger b = Q.subtract(ONE).divide(r);
        BigInteger g1 = a;
        BigInteger g2 = b;
        P.subtract(ONE).multiply(Q.subtract(ONE));
        while (!g2.equals(ZERO)) {
            BigInteger y = g1.divide(g2);
            BigInteger g3 = g1.subtract(y.multiply(g2));
            BigInteger u3 = u1.subtract(y.multiply(u2));
            BigInteger v3 = v1.subtract(y.multiply(v2));
            g1 = g2;
            g2 = g3;
            v1 = v2;
            v2 = v3;
            u1 = u2;
            u2 = u3;
        }
        BigInteger s = u1;
        BigInteger t = v1;
        return expQ.multiply(s).multiply(a).add(expP.multiply(t).multiply(b));
    }

    private void decode(byte[] encoding) throws EPinException {
        int qlength;
        int plength;
        int length = RSAPrivateCrtKey.bytesToInt(encoding, 0);
        if (length - 14 != 3 * ((plength = RSAPrivateCrtKey.bytesToInt(encoding, 2)) + (qlength = RSAPrivateCrtKey.bytesToInt(encoding, 4)))) {
            throw new EPinException("bad length information");
        }
        if (encoding[length - 8] != encoding[length - 16] || encoding[length - 7] != encoding[length - 15] || encoding[length - 6] != encoding[length - 14] || encoding[length - 5] != encoding[length - 13] || encoding[length - 4] != encoding[length - 12] || encoding[length - 3] != encoding[length - 11] || encoding[length - 2] != encoding[length - 10] || encoding[length - 1] != encoding[length - 9]) {
            throw new EPinException("Sanity test failed");
        }
        int index = 6;
        this._primeP = this.getBigInteger(encoding, index, plength);
        this._primeQ = this.getBigInteger(encoding, index += plength, qlength);
        BigInteger foo = this.getBigInteger(encoding, index += qlength, plength);
        this._coefficientP = this._primeQ.multiply(foo);
        BigInteger bar = this.getBigInteger(encoding, index += plength, qlength);
        this._coefficientQ = this._primeP.multiply(bar);
        index += qlength;
        if (!ONE.equals(foo.multiply(this._primeQ).mod(this._primeP))) {
            // empty if block
        }
        if (!ONE.equals(bar.multiply(this._primeP).mod(this._primeQ))) {
            // empty if block
        }
        this._exponentP = this.getBigInteger(encoding, index, plength);
        this._exponentQ = this.getBigInteger(encoding, index += plength, qlength);
        index += qlength;
        this._modulus = this._primeP.multiply(this._primeQ);
        this._exponent = this.calcPrivateExponent(this._primeP, this._primeQ, this._exponentP, this._exponentQ);
    }

    public byte[] encryptKey(byte[] pin) throws EPinException {
        byte[] pinKey = RSAPrivateCrtKey.makeKey(pin);
        byte[] thisEncoded = this.encode();
        byte[] tmp = new byte[thisEncoded.length - 2];
        System.arraycopy(thisEncoded, 2, tmp, 0, tmp.length);
        System.arraycopy(RSAPrivateCrtKey.encrypt(tmp, pinKey), 0, thisEncoded, 2, tmp.length);
        return thisEncoded;
    }

    public static RSAPrivateCrtKey decryptKey(byte[] pin, byte[] encryptedKey) throws EPinException {
        byte[] pinKey = RSAPrivateCrtKey.makeKey(pin);
        RSAPrivateCrtKey retVal = new RSAPrivateCrtKey();
        byte[] tmp = new byte[encryptedKey.length - 2];
        System.arraycopy(encryptedKey, 2, tmp, 0, tmp.length);
        byte[] decodedKey = RSAPrivateCrtKey.decrypt(tmp, pinKey);
        byte[] tmp2 = new byte[encryptedKey.length];
        System.arraycopy(encryptedKey, 0, tmp2, 0, 2);
        System.arraycopy(decodedKey, 0, tmp2, 2, decodedKey.length);
        retVal.decode(tmp2);
        return retVal;
    }
}

