/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashState;
import com.cryptomathic.crypto.hash.HashType;

public class Digest {
    private HashState _hState;
    private HashType _hType;
    private HashPadMode _hPadMode;

    protected Digest(HashType hType, HashPadMode hPadMode) {
        this._hType = hType;
        this._hPadMode = hPadMode;
        try {
            this._hState = HashState.start_hash(this._hType);
        }
        catch (HashException hashException) {
            // empty catch block
        }
    }

    protected Digest(HashType hType) {
        this(hType, HashPadMode.IMPPAD);
    }

    protected void engineUpdate(byte input) {
        byte[] byteArray = new byte[]{input};
        this._hState.do_hash(byteArray, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this._hState.do_hash(input, offset, len);
    }

    protected byte[] engineDigest() {
        byte[] res = null;
        byte[] m = new byte[]{};
        try {
            res = this._hState.stop_hash(this._hPadMode, m, 0, 0);
        }
        catch (HashException e) {
            res = null;
        }
        this.engineReset();
        return res;
    }

    protected void engineReset() {
        try {
            this._hState = HashState.start_hash(this._hType);
        }
        catch (HashException hashException) {
            // empty catch block
        }
    }
}

