/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.crypto.primes.PrimeGenerator;
import com.cryptomathic.crypto.primes.StrongPrimeGenerator;
import com.cryptomathic.security.EInvalidAlgorithmParameterException;
import com.cryptomathic.security.KeyPairGenerator;
import com.cryptomathic.security.spec.RSAParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;

public class KeyPairGeneratorRSA
extends KeyPairGeneratorSpi {
    private StrongPrimeGenerator _primeGenerator;
    private KeyPairGenerator _kpg;
    private RSAParameterSpec _parameterSpec;
    private Random _random;

    public void initialize(int strength, SecureRandom random) {
        if (strength < 512) {
            throw new InvalidParameterException("Strength must be at least 512");
        }
        this._parameterSpec = new RSAParameterSpec(strength);
        this._random = random;
        this._primeGenerator = new StrongPrimeGenerator(this._random);
        this._kpg = new KeyPairGenerator();
        try {
            this._kpg.initialize(this._parameterSpec, this._random, (PrimeGenerator)this._primeGenerator);
        }
        catch (EInvalidAlgorithmParameterException eiape) {
            throw new InvalidParameterException(eiape.getMessage());
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params != null) {
            try {
                this._parameterSpec = (RSAParameterSpec)params;
                if (this._parameterSpec.strength < 512) {
                    throw new InvalidParameterException("Strength must be at least 512");
                }
            }
            catch (ClassCastException e) {
                throw new InvalidAlgorithmParameterException("Incorrect parameter class");
            }
        }
        this._random = random;
        this._primeGenerator = new StrongPrimeGenerator(this._random);
        this._kpg = new KeyPairGenerator();
        try {
            this._kpg.initialize(this._parameterSpec, this._random, (PrimeGenerator)this._primeGenerator);
        }
        catch (EInvalidAlgorithmParameterException eiape) {
            throw new InvalidParameterException(eiape.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        if (this._kpg == null) {
            this.init();
        }
        return this._kpg.generateKeyPair();
    }

    private void init() {
        this._random = new SecureRandom();
        this._parameterSpec = new RSAParameterSpec(1024);
        this._primeGenerator = new StrongPrimeGenerator(this._random);
        this._kpg = new KeyPairGenerator();
        try {
            this._kpg.initialize(this._parameterSpec, this._random, (PrimeGenerator)this._primeGenerator);
        }
        catch (EInvalidAlgorithmParameterException eiape) {
            throw new InvalidParameterException(eiape.getMessage());
        }
    }
}

