/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.security.provider.CRMKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class KeyStoreCRM
extends KeyStoreSpi {
    private HashMap key_map = new HashMap();
    private static byte[] zero_mac = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public synchronized Enumeration engineAliases() {
        Vector v = new Vector(this.key_map.keySet());
        return v.elements();
    }

    public synchronized boolean engineContainsAlias(String alias) {
        return this.engineIsKeyEntry(alias);
    }

    public synchronized void engineDeleteEntry(String alias) throws KeyStoreException {
        CRMKey k = (CRMKey)this.key_map.remove(alias);
        if (k == null) {
            throw new KeyStoreException("The entry associated to '" + alias + "' was not found in the keystore.");
        }
    }

    public synchronized Certificate engineGetCertificate(String alias) {
        return null;
    }

    public synchronized String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    public synchronized Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    public synchronized Date engineGetCreationDate(String alias) {
        if (this.engineIsKeyEntry(alias)) {
            CRMKey key = (CRMKey)this.key_map.get(alias);
            return key.getCreationDate();
        }
        return null;
    }

    public synchronized Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineIsKeyEntry(alias)) {
            CRMKey ck = (CRMKey)this.key_map.get(alias);
            Key k = ck.getKey(password);
            if (k == null) {
                throw new UnrecoverableKeyException("Unable to recover key with supplied password");
            }
            return k;
        }
        return null;
    }

    public synchronized boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    public synchronized boolean engineIsKeyEntry(String alias) {
        return this.key_map.containsKey(alias);
    }

    public synchronized void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException {
        ObjectInputStream ois;
        block11: {
            int i;
            this.key_map = new HashMap();
            if (stream == null) {
                return;
            }
            ByteArrayOutputStream b_out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, 1024)) != -1) {
                b_out.write(buf, 0, i);
            }
            byte[] temp = b_out.toByteArray();
            ByteArrayInputStream b_mac = new ByteArrayInputStream(temp, temp.length - 20, 20);
            byte[] mac = new byte[20];
            b_mac.read(mac, 0, 20);
            ByteArrayInputStream b_in = new ByteArrayInputStream(temp);
            ois = new ObjectInputStream(b_in);
            try {
                int size = ois.readInt();
                for (i = 0; i < size; ++i) {
                    String alias = (String)ois.readObject();
                    CRMKey crm_key = (CRMKey)ois.readObject();
                    this.key_map.put(alias, crm_key);
                }
                if (password == null) break block11;
                try {
                    MessageDigest digest = MessageDigest.getInstance("SHA-1", "Cryptomathic");
                    digest.update(temp, 0, temp.length - 20);
                    digest.update(new String(password).getBytes());
                    byte[] new_mac = digest.digest();
                    if (mac.length != new_mac.length) {
                        throw new IOException("Integrity check of keystore failed");
                    }
                    for (i = 0; i < mac.length; ++i) {
                        if (mac[i] == new_mac[i]) continue;
                        throw new IOException("Integrity check of keystore failed");
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new NoSuchAlgorithmException("Unable to get instance of SHA-1 using provider Cryptomathic");
                }
                catch (NoSuchProviderException e) {
                    throw new NoSuchAlgorithmException("Unable to get instance of SHA-1 using provider Cryptomathic");
                }
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        ois.close();
    }

    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Attemot made to insert a certificate in this keystore, which is not supported");
    }

    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (chain != null) {
            throw new KeyStoreException("Storing keys with certificate chains attached is not supported");
        }
        if (this.engineIsKeyEntry(alias)) {
            this.engineDeleteEntry(alias);
        }
        if (this.engineIsCertificateEntry(alias)) {
            throw new KeyStoreException("Attempt made to overwrite a certificate entry with a key entry");
        }
        CRMKey k = new CRMKey(key, password);
        this.key_map.put(alias, k);
    }

    public synchronized void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("SetKeyEntry method not supported!");
    }

    public synchronized int engineSize() {
        return this.key_map.size();
    }

    public synchronized void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException {
        byte[] mac;
        ByteArrayOutputStream b_out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(b_out);
        Set key_set = this.key_map.entrySet();
        oos.writeInt(key_set.size());
        for (Map.Entry e : key_set) {
            String alias = (String)e.getKey();
            CRMKey crm_key = (CRMKey)e.getValue();
            oos.writeObject(alias);
            oos.writeObject(crm_key);
        }
        oos.close();
        byte[] temp = b_out.toByteArray();
        b_out.close();
        stream.write(temp);
        if (password != null) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1", "Cryptomathic");
                digest.update(temp);
                digest.update(new String(password).getBytes());
                mac = digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmException("Unable to get instance of SHA-1 using provider CrmJCE");
            }
            catch (NoSuchProviderException e) {
                throw new NoSuchAlgorithmException("Unable to get instance of SHA-1 using provider CrmJCE");
            }
        } else {
            mac = zero_mac;
        }
        stream.write(mac);
    }
}

