/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.spec;

import com.cryptomathic.crypto.primes.EPrimeParameterException;
import com.cryptomathic.crypto.primes.PrimeGenerator;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class RSAParameterSpec
implements AlgorithmParameterSpec {
    public int strength = 1024;
    public BigInteger e = null;
    public int modP = 2;
    public int resP = 1;
    public int modQ = 2;
    public int resQ = 1;
    public boolean crtRequired = true;

    public RSAParameterSpec(int strength_par) {
        this.strength = strength_par;
    }

    public RSAParameterSpec(int strength_par, BigInteger e_par) throws EPrimeParameterException {
        this.strength = strength_par;
        try {
            if (!e_par.testBit(0)) {
                throw new EPrimeParameterException("Required exponent is even");
            }
            this.e = this.copyBigInteger(e_par);
        }
        catch (NullPointerException ex) {
            this.e = null;
        }
    }

    public RSAParameterSpec(int strength_par, int modP_par, int resP_par, int modQ_par, int resQ_par, BigInteger e_par) throws EPrimeParameterException {
        this.strength = strength_par;
        try {
            if (!e_par.testBit(0)) {
                throw new EPrimeParameterException("Required exponent is even");
            }
            this.e = this.copyBigInteger(e_par);
        }
        catch (NullPointerException ex) {
            this.e = null;
        }
        if (!PrimeGenerator.validateResP(modP_par, resP_par)) {
            throw new EPrimeParameterException("Invalid requierment of the residue of the prime.");
        }
        this.modP = modP_par;
        if (!PrimeGenerator.validateResP(modQ_par, resQ_par)) {
            throw new EPrimeParameterException("Invalid requierment of the residue of the prime.");
        }
        this.modQ = modQ_par;
    }

    public void noCrt() {
        this.crtRequired = false;
    }

    private BigInteger copyBigInteger(BigInteger arg) {
        try {
            return arg.shiftRight(0);
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

