/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.admin.message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CommandTag {
    Noop(100),
    Logon(101),
    Logoff(102),
    GetRoles(103),
    LoadRoles(104),
    SetSettings(105),
    GetSettings(106),
    ListAdmins(110),
    CreateAdmin(111),
    ModifyAdmin(112),
    DeleteAdmin(113),
    CreateKey(130),
    CreateKeyPair(131),
    ExportPublicKey(132),
    ListZones(140),
    CreateZone(141),
    ModifyZone(142),
    DisableZone(143),
    ListPolicies(150),
    CreatePolicy(151),
    ModifyPolicy(152),
    ListCommandPolicies(153),
    ModifyCommandPolicy(154),
    ListAuditLog(180),
    ExportAuditLog(181),
    PurgeAuditLog(182),
    ListUsageLog(183),
    ListUsers(190),
    CreateUser(191),
    GetUser(192),
    DeleteUser(193),
    AssignZoneToUser(194),
    AssignPrivilegeToUser(195),
    AssignPrivilegeWithCertRequestToUser(196),
    RevokePrivilegeFromUser(197),
    SetUserState(198),
    ResetPassword(199),
    SetCertificate(200),
    ImportSigner33Zone(990, false),
    ImportSigner33User(991, false);

    private final int intTag;
    private final boolean isClientCmd;

    private CommandTag(int n2) {
        this.intTag = n2;
        this.isClientCmd = true;
    }

    private CommandTag(int n2, boolean bl) {
        this.intTag = n2;
        this.isClientCmd = bl;
    }

    public int getIntTag() {
        return this.intTag;
    }

    public boolean getIsClientCmd() {
        return this.isClientCmd;
    }

    public static CommandTag valueOf(int n) {
        for (CommandTag commandTag : CommandTag.values()) {
            if (n != commandTag.getIntTag()) continue;
            return commandTag;
        }
        throw new IndexOutOfBoundsException("No such command tag: " + n);
    }
}

