/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.authenticator;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyWithIdSimple {
    private int id;
    private BigInteger modulus;
    private BigInteger pubExp;

    public RSAKeyWithIdSimple(byte[] byArray) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n;
            if (dataInputStream.readByte() != 48) {
                throw new IOException("Key does not start with a sequence");
            }
            RSAKeyWithIdSimple.readLen(dataInputStream);
            if (dataInputStream.readByte() != 2) {
                throw new IOException("Key does not carry an id field");
            }
            int n2 = RSAKeyWithIdSimple.readLen(dataInputStream);
            if (n2 < 1) {
                throw new IOException("Key id is too small (< 1 bytes)");
            }
            if (n2 > 4) {
                throw new IOException("Key id is too large (> 4 bytes)");
            }
            long l = 0L;
            for (n = 0; n < n2; ++n) {
                l += (long)((dataInputStream.readByte() & 0xFF) << (n2 - n - 1) * 8);
            }
            if (l > Integer.MAX_VALUE) {
                throw new IOException("Key id is too large (> 0x7fffffff");
            }
            this.id = (int)l;
            if (dataInputStream.readByte() != 48) {
                throw new IOException("Key does not contain sequence with RSA key");
            }
            RSAKeyWithIdSimple.readLen(dataInputStream);
            if (dataInputStream.readByte() != 2) {
                throw new IOException("Key does not contain sequence with RSA modulus");
            }
            n = RSAKeyWithIdSimple.readLen(dataInputStream);
            byte[] byArray2 = new byte[n];
            dataInputStream.read(byArray2, 0, n);
            this.modulus = new BigInteger(1, byArray2);
            if (dataInputStream.readByte() != 2) {
                throw new IOException("Key does not contain sequence with RSA public exponent");
            }
            int n3 = RSAKeyWithIdSimple.readLen(dataInputStream);
            byte[] byArray3 = new byte[n3];
            dataInputStream.read(byArray3, 0, n3);
            this.pubExp = new BigInteger(1, byArray3);
            if (dataInputStream.available() != 0) {
                throw new IOException("Error in ASN.1 encoded data (excess data at end)");
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new Exception("Error in ASN.1 encoded data (not enough data)");
        }
    }

    private static int readLen(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if ((by & 0x80) == 0) {
            return by;
        }
        int n = by & 0x7F;
        if (n > 2 || n < 1) {
            throw new IOException("Invalid length field in ASN.1 encoded data");
        }
        int n2 = dataInputStream.readByte() & 0xFF;
        if (n == 2) {
            return n2 << 8 | dataInputStream.readByte() & 0xFF;
        }
        return n2;
    }

    public int getId() {
        return this.id;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.pubExp;
    }

    public byte[] getEncodedPublicKey() throws GeneralSecurityException {
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.modulus, this.pubExp);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        return publicKey.getEncoded();
    }
}

