/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.protocol;

import com.cryptomathic.signer.api.common.protocol.ProtocolIdentifier;
import com.cryptomathic.signer.common.protocol.Command;
import com.cryptomathic.signer.common.protocol.Protocol;
import com.cryptomathic.signer.common.protocol.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class DefaultProtocol
implements Protocol {
    private final ProtocolIdentifier protocolIdentifier;

    public DefaultProtocol(ProtocolIdentifier protocolIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
    }

    private final int getMagicNumber() {
        return this.protocolIdentifier.getIdentifier();
    }

    public Command deserializeCommand(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != this.getMagicNumber()) {
            throw new IOException("Unexpected command format.");
        }
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            return (Command)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Unknown command.");
        }
    }

    public void serializeCommand(OutputStream outputStream, Command command) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.getMagicNumber());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(command);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    public Response deserializeResponse(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != this.getMagicNumber()) {
            throw new IOException("Unexpected command format.");
        }
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object = objectInputStream.readObject();
            return (Response)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Unknown response object.");
        }
    }

    public void serializeResponse(OutputStream outputStream, Response response) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.getMagicNumber());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(response);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCompleteCommand(InputStream inputStream) throws IOException {
        inputStream.mark(8);
        try {
            int n = inputStream.available();
            if (n < 8) {
                boolean bl = false;
                return bl;
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            boolean bl = 8 + n2 <= n;
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }
}

