/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.roles;

import com.cryptomathic.signer.api.common.roles.Token;
import com.cryptomathic.signer.api.common.roles.TokenType;
import java.util.regex.Pattern;

class Tokenizer {
    private String buf;
    private int pos = 0;
    private int lineno = 1;

    public Tokenizer(String string) {
        this.buf = string;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    Token nextToken() {
        if (this.pos >= this.buf.length()) {
            return new Token(TokenType.EOF);
        }
        while (Character.isWhitespace(this.buf.charAt(this.pos))) {
            if (this.buf.charAt(this.pos) == '\n') {
                ++this.lineno;
            }
            ++this.pos;
            if (this.pos < this.buf.length()) continue;
            return new Token(TokenType.EOF);
        }
        if (this.buf.charAt(this.pos) == '[') {
            ++this.pos;
            return new Token(TokenType.LPAR);
        }
        if (this.buf.charAt(this.pos) == ']') {
            ++this.pos;
            return new Token(TokenType.RPAR);
        }
        if (this.buf.charAt(this.pos) == ',') {
            ++this.pos;
            return new Token(TokenType.COMMA);
        }
        if (Character.isDigit(this.buf.charAt(this.pos))) {
            StringBuilder stringBuilder = new StringBuilder();
            while (this.pos < this.buf.length() && Character.isDigit(this.buf.charAt(this.pos))) {
                stringBuilder.append(this.buf.charAt(this.pos));
                ++this.pos;
            }
            return new Token(TokenType.INT, stringBuilder.toString(), Integer.decode(stringBuilder.toString()));
        }
        if (Character.isLetter(this.buf.charAt(this.pos))) {
            StringBuilder stringBuilder = new StringBuilder();
            while (this.pos < this.buf.length() && (Character.isLetter(this.buf.charAt(this.pos)) || Character.isDigit(this.buf.charAt(this.pos)) || Character.isWhitespace(this.buf.charAt(this.pos)))) {
                stringBuilder.append(this.buf.charAt(this.pos));
                ++this.pos;
            }
            Pattern pattern = Pattern.compile("\\s+");
            String string = pattern.matcher(stringBuilder.toString()).replaceAll(" ");
            return new Token(TokenType.IDENTIFIER, string.trim());
        }
        return new Token(TokenType.PARSE_ERROR);
    }
}

