/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyLevel {
    EXPORTABLE(0, "Exportable", true),
    RECOVERABLE(10, "Recoverable", true),
    STANDARD(20, "Standard", true),
    PASSWORD_ENCRYPTED(30, "Password Encrypted", false);

    private final byte networkByte;
    private final String readable;
    private final boolean adminAssignable;

    private KeyLevel(byte by, String string2, boolean bl) {
        this.networkByte = by;
        this.readable = string2;
        this.adminAssignable = bl;
    }

    public boolean isAdminAssignable() {
        return this.adminAssignable;
    }

    public String getReadableText() {
        return this.readable;
    }

    public String toString() {
        return this.readable;
    }

    public byte getNetworkByte() {
        return this.networkByte;
    }

    public static KeyLevel findByNetworkByte(byte by) {
        for (KeyLevel keyLevel : KeyLevel.values()) {
            if (keyLevel.networkByte != by) continue;
            return keyLevel;
        }
        return null;
    }
}

