/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.zones;

import com.cryptomathic.signer.api.common.zones.ZoneItem;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Hostname
implements ZoneItem {
    private String name;
    private InetAddress[] ips;
    private int[] ipsAsInt;

    public String getName() {
        return this.name;
    }

    public InetAddress[] getIpAddresses() {
        return this.isAccessible() ? this.ips : new InetAddress[]{};
    }

    public static boolean looksParsable(String string) {
        String string2 = ".-_";
        for (char c : string.trim().toCharArray()) {
            if (Character.isLetterOrDigit(c) || string2.contains("" + c)) continue;
            return false;
        }
        return true;
    }

    public Hostname(String string) {
        this.name = string.trim();
    }

    public String toString() {
        return this.name;
    }

    public boolean isAccessible() {
        if (this.ips != null) {
            return this.ips.length > 0;
        }
        try {
            this.ips = InetAddress.getAllByName(this.name);
            this.ipsAsInt = new int[this.ips.length];
            int n = 0;
            for (InetAddress inetAddress : this.ips) {
                byte[] byArray = inetAddress.getAddress();
                int n2 = byArray[0] & 0xFF;
                n2 = (n2 << 8) + (byArray[1] & 0xFF);
                n2 = (n2 << 8) + (byArray[2] & 0xFF);
                this.ipsAsInt[n] = n2 = (n2 << 8) + (byArray[3] & 0xFF);
                ++n;
            }
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            this.ips = new InetAddress[0];
            this.ipsAsInt = new int[0];
            return false;
        }
    }

    public boolean doesInclude(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            return false;
        }
        if (!this.isAccessible()) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] & 0xFF;
        n = (n << 8) + (byArray[1] & 0xFF);
        n = (n << 8) + (byArray[2] & 0xFF);
        n = (n << 8) + (byArray[3] & 0xFF);
        return this.doesInclude(n);
    }

    public int getMask() {
        return 32;
    }

    private boolean doesInclude(int n) {
        if (!this.isAccessible()) {
            return false;
        }
        if (this.ipsAsInt == null) {
            return false;
        }
        for (int n2 : this.ipsAsInt) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }
}

