/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.zones;

import com.cryptomathic.signer.api.common.zones.Hostname;
import com.cryptomathic.signer.api.common.zones.IPv4AddressMask;
import com.cryptomathic.signer.api.common.zones.IPv6AddressMask;
import com.cryptomathic.signer.api.common.zones.ZoneItem;
import com.cryptomathic.signer.common.exceptions.ZoneItemParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ZoneItemType {
    IPv4_MASK{

        public boolean isOfType(String string) {
            return IPv4AddressMask.looksParsable(string);
        }

        public ZoneItem parseInto(String string) throws ZoneItemParseException {
            return new IPv4AddressMask(string);
        }
    }
    ,
    IPv6_MASK{

        public boolean isOfType(String string) {
            return IPv6AddressMask.looksParsable(string);
        }

        public ZoneItem parseInto(String string) throws ZoneItemParseException {
            return new IPv6AddressMask(string);
        }
    }
    ,
    HOSTNAME{

        public boolean isOfType(String string) {
            return Hostname.looksParsable(string);
        }

        public ZoneItem parseInto(String string) throws ZoneItemParseException {
            return new Hostname(string);
        }
    };


    abstract boolean isOfType(String var1);

    abstract ZoneItem parseInto(String var1) throws ZoneItemParseException;

    public static ZoneItem parseIntoInstance(String string) throws ZoneItemParseException {
        for (ZoneItemType zoneItemType : ZoneItemType.values()) {
            if (!zoneItemType.isOfType(string)) continue;
            return zoneItemType.parseInto(string);
        }
        throw new ZoneItemParseException("No zone item type matching: " + string);
    }
}

