/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.user.message.AnonCommandType;
import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserProtocolType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AnonCommand
extends UserCommand {
    private int version;
    private int command;
    private String username;

    public AnonCommand() {
        super(UserProtocolType.ANONYMOUS, null);
    }

    public AnonCommand(AnonCommandType anonCommandType, int n) {
        super(UserProtocolType.ANONYMOUS, null);
        this.command = anonCommandType.getCommandIdentifierAsByte();
        this.version = n;
        this.username = "";
    }

    public AnonCommand(AnonCommandType anonCommandType, int n, String string) {
        super(UserProtocolType.ANONYMOUS, null);
        this.command = anonCommandType.getCommandIdentifierAsByte();
        this.version = n;
        this.username = string;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCommand() {
        return this.command;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public static AnonCommand fromUserCommand(UserCommand userCommand) throws IOException {
        AnonCommand anonCommand = new AnonCommand();
        anonCommand.setClientAddress(userCommand.getClientAddress());
        anonCommand.setTypeAndPayload(userCommand.getCommandType(), userCommand.getPayload());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userCommand.getPayload()));
        anonCommand.version = dataInputStream.readInt();
        anonCommand.command = dataInputStream.readInt();
        anonCommand.username = UserCommand.readString(dataInputStream);
        return anonCommand;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.command);
        UserCommand.writeString(dataOutputStream, this.username);
        return byteArrayOutputStream.toByteArray();
    }
}

