/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.common.types.AuthenticationLevel;
import com.cryptomathic.signer.api.common.types.KeyLevel;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.api.user.PolicyEntry;
import com.cryptomathic.signer.api.user.errors.UserErrorCodes;
import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserResponse;
import com.cryptomathic.signer.api.user.message.UserResponseType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonResponse
extends UserResponse {
    public static final int VERSION_CURRENT = 1;
    private int version = 1;
    private List<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
    private int errorCode = UserErrorCodes.OK.getErrorCode();

    public AnonResponse() {
        super(UserResponseType.UNENCRYPTED, null);
    }

    public AnonResponse(UserErrorCodes userErrorCodes) {
        this();
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public AnonResponse(UserErrorCodes userErrorCodes, List<PolicyEntry> list) {
        this();
        this.errorCode = userErrorCodes.getErrorCode();
        this.policyEntries = list;
    }

    public int getVersion() {
        return this.version;
    }

    public UserErrorCodes getUserErrorCode() {
        return UserErrorCodes.valueOf(this.errorCode);
    }

    public void setUserErrorCode(UserErrorCodes userErrorCodes) {
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public void setPolicyEntries(List<PolicyEntry> list) {
        this.policyEntries = list;
    }

    public List<PolicyEntry> getPolicyEntries() {
        return this.policyEntries;
    }

    public static AnonResponse fromUserResponse(UserResponse userResponse) throws IOException {
        AnonResponse anonResponse = new AnonResponse();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userResponse.getPayload()));
        if (userResponse.getResponseType() != UserResponseType.UNENCRYPTED) {
            throw new IOException("Expected an AnonResponse here");
        }
        anonResponse.setTypeAndPayload(userResponse.getResponseType(), userResponse.getPayload());
        anonResponse.version = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        anonResponse.policyEntries = AnonResponse.readPolicyEntries(dataInputStream, n);
        anonResponse.errorCode = dataInputStream.readInt();
        return anonResponse;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.policyEntries == null ? 0 : this.policyEntries.size());
        this.writePolicyEntries(dataOutputStream, this.policyEntries);
        dataOutputStream.writeInt(this.errorCode);
        return byteArrayOutputStream.toByteArray();
    }

    private void writePolicyEntries(DataOutputStream dataOutputStream, List<PolicyEntry> list) throws IOException {
        if (list == null) {
            return;
        }
        for (PolicyEntry policyEntry : list) {
            dataOutputStream.writeLong(policyEntry.id);
            UserCommand.writeString(dataOutputStream, policyEntry.name);
            dataOutputStream.writeByte(policyEntry.authLevel.getNetworkByte());
            dataOutputStream.writeByte(policyEntry.keyLevel.getNetworkByte());
            dataOutputStream.writeByte(policyEntry.canSign ? 1 : 0);
            dataOutputStream.writeByte(policyEntry.canDecrypt ? 1 : 0);
            dataOutputStream.writeByte(policyEntry.enabled ? 1 : 0);
            dataOutputStream.writeInt(policyEntry.keys == null ? 0 : policyEntry.keys.size());
            this.writeKeyEntries(dataOutputStream, policyEntry.keys);
        }
    }

    private void writeKeyEntries(DataOutputStream dataOutputStream, List<KeyEntry> list) throws IOException {
        if (list == null) {
            return;
        }
        for (KeyEntry keyEntry : list) {
            UserCommand.writeByteArray(dataOutputStream, keyEntry.certificateBytes);
            UserCommand.writeString(dataOutputStream, keyEntry.displayText);
            dataOutputStream.writeLong(keyEntry.keyId);
            dataOutputStream.writeLong(keyEntry.optionalExpiredDate);
            UserCommand.writeByteArray(dataOutputStream, keyEntry.publicKey);
        }
    }

    private static List<PolicyEntry> readPolicyEntries(DataInputStream dataInputStream, int n) throws IOException {
        ArrayList<PolicyEntry> arrayList = new ArrayList<PolicyEntry>(n);
        for (int i = 0; i < n; ++i) {
            PolicyEntry policyEntry = new PolicyEntry();
            policyEntry.id = dataInputStream.readLong();
            policyEntry.name = UserCommand.readString(dataInputStream);
            policyEntry.authLevel = AuthenticationLevel.findByNetworkByte(dataInputStream.readByte());
            policyEntry.keyLevel = KeyLevel.findByNetworkByte(dataInputStream.readByte());
            policyEntry.canSign = dataInputStream.readByte() != 0;
            policyEntry.canDecrypt = dataInputStream.readByte() != 0;
            policyEntry.enabled = dataInputStream.readByte() != 0;
            int n2 = dataInputStream.readInt();
            policyEntry.keys = AnonResponse.readKeyEntries(dataInputStream, n2);
            arrayList.add(policyEntry);
        }
        return arrayList;
    }

    private static List<KeyEntry> readKeyEntries(DataInputStream dataInputStream, int n) throws IOException {
        ArrayList<KeyEntry> arrayList = new ArrayList<KeyEntry>(n);
        for (int i = 0; i < n; ++i) {
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.certificateBytes = UserCommand.readByteArray(dataInputStream);
            keyEntry.displayText = UserCommand.readString(dataInputStream);
            keyEntry.keyId = dataInputStream.readLong();
            keyEntry.optionalExpiredDate = dataInputStream.readLong();
            keyEntry.publicKey = UserCommand.readByteArray(dataInputStream);
            arrayList.add(keyEntry);
        }
        return arrayList;
    }
}

