/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserProtocolType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MainCommand
extends UserCommand {
    private int version;
    private long sessionId;
    private byte[] encryptedContent;

    public MainCommand() {
        super(UserProtocolType.AUTHENTICATED, null);
    }

    public MainCommand(long l, byte[] byArray, int n) {
        super(UserProtocolType.AUTHENTICATED, null);
        this.sessionId = l;
        this.encryptedContent = byArray;
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public static MainCommand fromUserCommand(UserCommand userCommand) throws IOException {
        MainCommand mainCommand = new MainCommand();
        mainCommand.setClientAddress(userCommand.getClientAddress());
        mainCommand.setTypeAndPayload(userCommand.getCommandType(), userCommand.getPayload());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userCommand.getPayload()));
        mainCommand.version = dataInputStream.readInt();
        mainCommand.sessionId = dataInputStream.readLong();
        mainCommand.encryptedContent = UserCommand.readByteArray(dataInputStream);
        return mainCommand;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeLong(this.sessionId);
        UserCommand.writeByteArray(dataOutputStream, this.encryptedContent);
        return byteArrayOutputStream.toByteArray();
    }
}

