/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UserCommandType {
    ACTIVATE_ACCOUNT("Activate Account", 1),
    CHANGE_PASSWORD("Change Password", 2),
    LIST_TOKENS("List Tokens", 11),
    GET_CHALLENGE("Get Challenge", 12),
    ESCALATE("Escalate", 13),
    GET_KEYS("Get Keys", 21),
    DO_OPERATION("Do Operation", 22),
    EXPORT_KEY("Export Key", 23),
    SET_CERTIFICATE("Set Certificate", 24),
    CREATE_NEW_KEY("Create new Key", 25),
    NOOP("No Operation", 99),
    LOGOFF("Logoff", 100);

    private final String readable;
    private final int commandId;

    private UserCommandType(String string2, int n2) {
        this.readable = string2;
        this.commandId = n2;
    }

    public String getReadableString() {
        return this.readable;
    }

    public byte getCommandIdentifierAsByte() {
        return (byte)this.commandId;
    }

    public static UserCommandType findByCommandIdentifier(byte by) {
        if (by < 0) {
            return null;
        }
        for (UserCommandType userCommandType : UserCommandType.values()) {
            if (by != userCommandType.getCommandIdentifierAsByte()) continue;
            return userCommandType;
        }
        return null;
    }
}

