/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user;

import com.cryptomathic.common.utils.ByteArrays;
import com.cryptomathic.signer.sdk.user.SignerDecryption;

public class DecryptionFactory {
    private static byte[] parsePKCS1EncodedMessage(byte[] byArray) throws SignerDecryption.ParsingFailedException {
        int n;
        if (byArray == null || byArray.length < 5 || byArray[0] != 0 || byArray[1] != 2) {
            throw new SignerDecryption.ParsingFailedException("Data parsing failed: Data does not appear to be PKCS#1 encoded");
        }
        byte by = 0;
        for (n = 2; n < byArray.length && byArray[n] != by; ++n) {
        }
        if (n == byArray.length || n < 10) {
            throw new SignerDecryption.ParsingFailedException("Parsing failed: Could not extract message from PKCS#1 encoded data");
        }
        return ByteArrays.extract(byArray, n + 1);
    }

    public static SignerDecryption doPkcs1Decryption(final byte[] byArray) {
        return new SignerDecryption(){

            public byte[] processDecryptedData(byte[] byArray2) throws SignerDecryption.ParsingFailedException {
                return DecryptionFactory.parsePKCS1EncodedMessage(byArray2);
            }

            public byte[] getEncryption() {
                return byArray;
            }
        };
    }

    public static SignerDecryption doRawDecryption(final byte[] byArray) {
        return new SignerDecryption(){

            public byte[] processDecryptedData(byte[] byArray2) {
                return byArray2;
            }

            public byte[] getEncryption() {
                return byArray;
            }
        };
    }
}

