/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.crypto;

import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;

public class BlindSignatures {
    private final RSAPublicKey pubKey;
    private final Random rand;

    public BlindSignatures(byte[] byArray) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            this.pubKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            this.rand = new SecureRandom();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot setup blind signatures");
        }
    }

    public BlindSignatureData blindData(byte[] byArray) {
        BigInteger bigInteger;
        final BigInteger bigInteger2 = this.pubKey.getModulus();
        BigInteger bigInteger3 = this.pubKey.getPublicExponent();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        if (bigInteger4.compareTo(bigInteger2) >= 0) {
            throw new InvalidParameterException("data cannot be larger than modulus");
        }
        while ((bigInteger = new BigInteger(bigInteger2.bitLength(), this.rand)).equals(BigInteger.ZERO) || bigInteger.compareTo(bigInteger2) >= 0 || bigInteger.gcd(bigInteger2).compareTo(BigInteger.ONE) > 0) {
        }
        final BigInteger bigInteger5 = bigInteger.modPow(bigInteger3, bigInteger2).multiply(bigInteger4).mod(bigInteger2);
        final BigInteger bigInteger6 = bigInteger;
        return new BlindSignatureData(){

            public byte[] getData() {
                return BlindSignatures.serialiseGroupElement(bigInteger5, bigInteger2);
            }

            public UnblindData getUnblindData() {
                return new UnblindData(bigInteger6);
            }
        };
    }

    public byte[] unblindSignature(byte[] byArray, UnblindData unblindData) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.pubKey.getModulus();
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new InvalidParameterException("signature cannot be larger than modulus");
        }
        BigInteger bigInteger3 = bigInteger.multiply(unblindData.random.modInverse(bigInteger2)).mod(bigInteger2);
        return BlindSignatures.serialiseGroupElement(bigInteger3, bigInteger2);
    }

    private static byte[] serialiseGroupElement(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < (n = (bigInteger2.bitLength() + 7) / 8)) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
            byArray = byArray2;
        } else if (byArray.length == n + 1 && byArray[0] == 0) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 1, byArray3, 0, n);
            byArray = byArray3;
        }
        return byArray;
    }

    public final class UnblindData {
        private final BigInteger random;

        private UnblindData(BigInteger bigInteger) {
            this.random = bigInteger;
        }
    }

    public static interface BlindSignatureData {
        public byte[] getData();

        public UnblindData getUnblindData();
    }
}

