/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.crypto;

import com.cryptomathic.common.utils.ByteArrays;
import com.cryptomathic.signer.sdk.user.crypto.ClientSrp;
import com.cryptomathic.signer.sdk.user.crypto.CryptoUtils;
import com.cryptomathic.signer.sdk.user.crypto.DecryptFailedException;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolCommandTag;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolResponseTag;
import java.util.Arrays;

public class KeyStateHandler {
    private volatile byte[] srpSecret;
    private int sequenceNumber;

    private void writeNetworkInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    private static int readNetworkInt(byte[] byArray, int n) {
        return (0xFF & byArray[n]) << 24 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3];
    }

    private static short getNetworkShort(byte[] byArray, int n) {
        return (short)((0xFF & byArray[n + 0]) << 8 | 0xFF & byArray[n + 1]);
    }

    private static void writeNetworkShort(byte[] byArray, int n, short s) {
        byArray[n] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public KeyStateHandler(byte[] byArray) {
        this.srpSecret = byArray;
        this.sequenceNumber = 0;
    }

    public void updateSrpSecret(byte[] byArray) {
        for (int i = 0; i < this.srpSecret.length; ++i) {
            this.srpSecret[i] = (byte)(this.srpSecret[i] ^ byArray[i]);
        }
    }

    public byte[] encryptCommand(byte[] byArray) {
        byte[] byArray2 = ClientSrp.getEncKey(this.srpSecret);
        byte[] byArray3 = ClientSrp.getMacKey(this.srpSecret);
        byte[] byArray4 = new byte[byArray.length + 10];
        KeyStateHandler.writeNetworkShort(byArray4, 0, UserProtocolCommandTag.SEQUENCE_NUMBER.getValue());
        this.writeNetworkInt(byArray4, 2, 4);
        this.writeNetworkInt(byArray4, 6, this.sequenceNumber);
        System.arraycopy(byArray, 0, byArray4, 10, byArray.length);
        byte[] byArray5 = CryptoUtils.createMac(byArray3, byArray4);
        byte[] byArray6 = new byte[byArray4.length + 16];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        return CryptoUtils.encrypt(byArray2, byArray6);
    }

    public byte[] getVerifiedResponse(byte[] byArray) throws DecryptFailedException {
        byte[] byArray2;
        byte[] byArray3 = ClientSrp.getEncKey(this.srpSecret);
        byte[] byArray4 = ClientSrp.getMacKey(this.srpSecret);
        byte[] byArray5 = CryptoUtils.decrypt(byArray3, byArray);
        byte[] byArray6 = ByteArrays.resize(byArray5, byArray5.length - 16);
        byte[] byArray7 = ByteArrays.extract(byArray5, byArray5.length - 16);
        if (!Arrays.equals(byArray7, byArray2 = CryptoUtils.createMac(byArray4, byArray6))) {
            throw new DecryptFailedException("Mac failed");
        }
        short s = KeyStateHandler.getNetworkShort(byArray6, 0);
        if (UserProtocolResponseTag.SEQUENCE_NUMBER.getValue() != s) {
            throw new DecryptFailedException("Invalid response format");
        }
        int n = KeyStateHandler.readNetworkInt(byArray6, 2);
        if (4 != n) {
            throw new DecryptFailedException("Invalid response format");
        }
        int n2 = this.sequenceNumber + 1;
        int n3 = KeyStateHandler.readNetworkInt(byArray6, 6);
        if (n2 != n3) {
            throw new DecryptFailedException("Invalid response sequence, replay attack?");
        }
        this.sequenceNumber += 2;
        return ByteArrays.extract(byArray6, 10);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }
}

