/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.utils;

import com.cryptomathic.signer.sdk.user.crypto.CryptoUtils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;

public class AuthenticatorUtils {
    private static SecureRandom rnd = new SecureRandom();

    public static byte[] getEncryptedOtpAndSalt(String string, byte[] byArray, RSAPublicKey rSAPublicKey) throws GeneralSecurityException {
        if (rSAPublicKey == null) {
            throw new IllegalArgumentException("No CTK defined");
        }
        return CryptoUtils.rsaEncrypt(AuthenticatorUtils.getOtpAndSalt(string, byArray), rSAPublicKey);
    }

    public static byte[] getOtpAndSalt(String string, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    private static void encodeAuthenticatorBlockLength(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
        byArray[n + 1] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n + 2] = (byte)((l & 0xFF00L) >> 8);
        byArray[n + 3] = (byte)((l & 0xFFL) >> 0);
    }

    public static byte[] getKeyMaterial(String string, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[4 + byArray2.length + 4 + byArray.length];
        AuthenticatorUtils.encodeAuthenticatorBlockLength(byArray2.length, byArray3, 0);
        System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
        AuthenticatorUtils.encodeAuthenticatorBlockLength(byArray.length, byArray3, 4 + byArray2.length);
        System.arraycopy(byArray, 0, byArray3, 4 + byArray2.length + 4, byArray.length);
        return CryptoUtils.createSha256Digest(new byte[][]{byArray3});
    }

    public static byte[] getSalt(int n) {
        byte[] byArray = new byte[n];
        rnd.nextBytes(byArray);
        return byArray;
    }
}

