/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.utils;

import com.cryptomathic.signer.api.user.message.UserCommandType;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolCommandTag;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EncryptedCommand {
    private ByteArrayOutputStream bso = new ByteArrayOutputStream();
    private DataOutputStream dso = new DataOutputStream(this.bso);

    public EncryptedCommand(UserCommandType userCommandType) throws IOException {
        this.dso.writeShort(UserProtocolCommandTag.COMMAND_ID.getValue());
        this.dso.writeInt(1);
        this.dso.writeByte(userCommandType.getCommandIdentifierAsByte());
    }

    public EncryptedCommand add(UserProtocolCommandTag userProtocolCommandTag, int n) throws IOException {
        this.dso.writeShort(userProtocolCommandTag.getValue());
        this.dso.writeInt(4);
        this.dso.writeInt(n);
        return this;
    }

    public EncryptedCommand add(UserProtocolCommandTag userProtocolCommandTag, long l) throws IOException {
        this.dso.writeShort(userProtocolCommandTag.getValue());
        this.dso.writeInt(8);
        this.dso.writeLong(l);
        return this;
    }

    public EncryptedCommand add(UserProtocolCommandTag userProtocolCommandTag, String string) throws IOException {
        this.dso.writeShort(userProtocolCommandTag.getValue());
        byte[] byArray = string.getBytes("UTF-8");
        this.dso.writeInt(byArray.length);
        this.dso.write(byArray);
        return this;
    }

    public EncryptedCommand add(UserProtocolCommandTag userProtocolCommandTag, byte[] byArray) throws IOException {
        this.dso.writeShort(userProtocolCommandTag.getValue());
        this.dso.writeInt(byArray.length);
        this.dso.write(byArray);
        return this;
    }

    public EncryptedCommand add(UserProtocolCommandTag userProtocolCommandTag, boolean bl) throws IOException {
        this.dso.writeShort(userProtocolCommandTag.getValue());
        this.dso.writeInt(1);
        this.dso.writeBoolean(bl);
        return this;
    }

    public byte[] toByteArray() {
        return this.bso.toByteArray();
    }
}

