/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.server.configuration;

import com.cryptomathic.common.utils.Hex;
import com.cryptomathic.common.utils.PropertyReader;
import com.cryptomathic.signer.common.utils.InvalidConfigurationException;
import com.cryptomathic.signer.server.configuration.SignerConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class PropertiesConfiguration
implements SignerConfiguration {
    static final String DEFAULT_FILE_NAME = "defaults.properties";
    static final String OVERRIDE_FILE_NAME = "server.properties";
    private static String OVERRIDE_FILE_NAME_Actual;
    private Properties properties = new Properties();
    private final int userPort;
    private final int adminClientPort;
    private final int initialisationPort;
    private byte[] databasePassword;
    private final String databaseUserName;
    private final long clientConnectionTimeoutInMs;

    public PropertiesConfiguration(InputStream inputStream, InputStream inputStream2) throws InvalidConfigurationException {
        try {
            this.properties.load(inputStream);
            if (inputStream2 != null) {
                this.properties.load(inputStream2);
            } else {
                this.properties.store(new FileOutputStream(OVERRIDE_FILE_NAME), "Cryptomathic Signer configuration");
            }
        }
        catch (IOException iOException) {
            throw new InvalidConfigurationException("Unable to load server proporties", iOException);
        }
        try {
            PropertyReader propertyReader = new PropertyReader(this.properties);
            this.userPort = propertyReader.readAsInteger("signer.user.port", 9123);
            this.adminClientPort = propertyReader.readAsInteger("signer.adminclient.port", 9124);
            this.initialisationPort = propertyReader.readAsInteger("signer.initialisation.port", 9125);
            this.databaseUserName = propertyReader.readAsString("signer.databaseusername", "signer");
            this.databasePassword = propertyReader.readAsHex("signer.databasepassword", "2A0214F7424CC1CA22863C6142DC31D1");
            int n = propertyReader.readAsInteger("signer.clientconnection.timeout.minutes", 60);
            if (n < 1) {
                throw new InvalidConfigurationException("Cannot set connection timeout to less than 1");
            }
            this.clientConnectionTimeoutInMs = TimeUnit.SECONDS.toMillis(60 * n);
        }
        catch (Exception exception) {
            throw new InvalidConfigurationException("Unable to parse server properties: " + exception.getMessage());
        }
    }

    public PropertiesConfiguration() throws InvalidConfigurationException {
        this(PropertiesConfiguration.class.getResourceAsStream(DEFAULT_FILE_NAME), PropertiesConfiguration.getOverrideStream(OVERRIDE_FILE_NAME));
    }

    private static InputStream getOverrideStream(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                OVERRIDE_FILE_NAME_Actual = file.getAbsolutePath();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileInputStream = null;
        }
        return fileInputStream;
    }

    public int getUserPort() {
        return this.userPort;
    }

    public int getAdminClientPort() {
        return this.adminClientPort;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public String getDatabasePassword() {
        return Hex.encode(this.databasePassword);
    }

    public void setDatabasePassword(String string) throws FileNotFoundException, IOException {
        this.databasePassword = Hex.decode(string);
        this.properties.setProperty("signer.databasepassword", string);
        this.properties.store(new FileOutputStream(OVERRIDE_FILE_NAME), "Cryptomathic Signer configuration");
    }

    public String getDatabaseUrl() {
        return null;
    }

    public int getInitialisationClientPort() {
        return this.initialisationPort;
    }

    public long getClientConnectionTimeoutInMiliseconds() {
        return this.clientConnectionTimeoutInMs;
    }

    public static String getOVERRIDE_FILE_NAME_Actual() {
        return OVERRIDE_FILE_NAME_Actual;
    }
}

