/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.AuthenticationErrorException;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.Slice;
import com.cryptomathic.ss.customer.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuthUtils {
    protected static final int L = 20;
    protected static byte[] opad = new byte[20];
    protected static byte[] ipad = new byte[20];
    protected byte[] x = new byte[60];
    protected byte[] y = new byte[40];
    protected byte[] z = new byte[40];
    protected Slice xs = new Slice(this.x);
    protected Slice ys = new Slice(this.y);
    protected Slice zs = new Slice(this.z);
    protected Slice key = new Slice(this.z, 0, 20);
    protected int sessionID;
    protected boolean initialised = false;
    protected byte[] seed;
    protected boolean seedInitialised = false;
    protected static final boolean debugMode = false;

    protected void initialise() {
        if (!this.initialised) {
            this.initialised = true;
            this.seedInitialised = false;
        }
    }

    public AuthUtils() {
        this.initialise();
    }

    public AuthUtils(byte[] byArray, byte[] byArray2) throws CustCommException {
        this.initialise();
        this.init(byArray, byArray2);
    }

    public void setSessionID(int n) {
        this.sessionID = n;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    protected static byte[] computeSessionKey(byte[] byArray, byte[] byArray2, byte[] byArray3) throws CustCommException {
        AuthUtils.printByteArray("prf2 key", byArray);
        AuthUtils.printByteArray("prf2 seed", byArray2);
        AuthUtils authUtils = new AuthUtils(byArray, byArray2);
        authUtils.printState();
        byte[] byArray4 = authUtils.PRF();
        AuthUtils.printByteArray("prf2 target", byArray4);
        for (int i = 0; i < 20; ++i) {
            byArray3[i] = byArray4[i];
        }
        return authUtils.PRF();
    }

    public byte[] getDigipassTarget(byte[] byArray, OutputStream outputStream, byte[] byArray2) throws CustCommException, IOException {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = AuthUtils.computeSessionKey(this.extend(byArray, 20), byArray2, byArray3);
        outputStream.write(byArray3);
        return byArray4;
    }

    public byte[] getTotpTarget(byte[] byArray, OutputStream outputStream, byte[] byArray2) throws CustCommException, IOException {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = AuthUtils.computeSessionKey(this.extend(byArray, 20), byArray2, byArray3);
        outputStream.write(byArray3);
        return byArray4;
    }

    public byte[] getFingerPrintTarget(byte[] byArray, OutputStream outputStream, byte[] byArray2) throws CustCommException, IOException {
        AuthUtils authUtils = new AuthUtils(byArray2, byArray2);
        byte[] byArray3 = authUtils.encrypt(byArray);
        Utils.writeInt(byArray3.length, outputStream);
        outputStream.write(byArray3);
        return authUtils.PRF();
    }

    public void perturbWithSessionKey() throws CustCommException {
        if (this.seedInitialised) {
            this.perturb(this.seed);
            this.seedInitialised = false;
        }
    }

    protected static void ByteArrayCopy(Slice slice, Slice slice2) {
        slice2.set(slice.get());
    }

    protected void xorKey() throws CustCommException {
        AuthUtils.xor(this.key, opad, this.ys);
        AuthUtils.xor(this.key, ipad, this.xs);
    }

    public void printState() {
        AuthUtils.printByteArray("x: ", this.x);
        AuthUtils.printByteArray("y: ", this.y);
        AuthUtils.printByteArray("z: ", this.z);
    }

    public static int getStateLength() {
        return 60;
    }

    public byte[] getState() {
        byte[] byArray = new byte[60];
        for (int i = 0; i < 20; ++i) {
            byArray[i] = this.z[i];
            byArray[20 + i] = this.x[20 + i];
            byArray[40 + i] = this.x[40 + i];
        }
        return byArray;
    }

    public void setState(byte[] byArray) throws CustCommException {
        for (int i = 0; i < 20; ++i) {
            this.z[i] = byArray[i];
            this.x[20 + i] = byArray[20 + i];
            this.x[40 + i] = byArray[40 + i];
        }
        this.xorKey();
    }

    public void destroyState() {
        int n;
        for (n = 0; n < 60; ++n) {
            this.x[n] = 0;
        }
        for (n = 0; n < 40; ++n) {
            this.y[n] = 0;
            this.z[n] = 0;
        }
    }

    private byte[] extend(byte[] byArray, int n) {
        byte[] byArray2 = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray2[i] = byArray[i % byArray.length];
        }
        return byArray2;
    }

    public void init(byte[] byArray, byte[] byArray2) throws CustCommException {
        AuthUtils.printByteArray("init key", byArray);
        AuthUtils.printByteArray("init seed", byArray2);
        byte[] byArray3 = AuthUtils.hash(byArray2);
        if (byArray.length != 20) {
            throw new CustCommException("Initial key for prf has invalid length " + byArray.length);
        }
        this.setState(AuthUtils.concat(byArray, byArray3, byArray3));
    }

    public void perturb(byte[] byArray) throws CustCommException {
        AuthUtils.printByteArray("perturb with", byArray);
        if (byArray.length == 0) {
            return;
        }
        AuthUtils.ByteArrayCopy(new Slice(this.x, 0, 20), this.key);
        AuthUtils.hash(new Slice(byArray), new Slice(this.z, 20, 20));
        this.printState();
        AuthUtils.hash(this.zs, new Slice(this.y, 20, 20));
        this.printState();
        AuthUtils.hash(this.ys, this.key);
        this.xorKey();
    }

    protected byte[] PRF() throws CustCommException {
        Slice slice = new Slice(this.y, 20, 20);
        AuthUtils.hash(new Slice(this.x, 0, 40), slice);
        AuthUtils.hash(this.ys, new Slice(this.x, 20, 20));
        AuthUtils.hash(this.xs, slice);
        byte[] byArray = AuthUtils.hash(this.y);
        AuthUtils.printByteArray("PRF returned", byArray);
        return byArray;
    }

    protected void PRF(byte[] byArray, int n) throws CustCommException {
        byte[] byArray2 = this.PRF();
        for (int i = 0; i < 20 && n + i < byArray.length; ++i) {
            byArray[n + i] = byArray2[i];
        }
    }

    protected byte[] PRF(int n) throws CustCommException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += 20) {
            this.PRF(byArray, i);
        }
        return byArray;
    }

    public static byte[] MAC(byte[] byArray, byte[] byArray2) throws CustCommException {
        byte[] byArray3 = AuthUtils.xor(byArray, opad);
        byte[] byArray4 = AuthUtils.xor(byArray, ipad);
        return AuthUtils.hash(AuthUtils.concat(byArray3, AuthUtils.hash(AuthUtils.concat(byArray4, byArray2))));
    }

    protected static void xor(Slice slice, byte[] byArray, Slice slice2) throws CustCommException {
        if (slice.length != byArray.length) {
            throw new CustCommException("Internal error : Tried to XOR arrays of different lengths.");
        }
        byte[] byArray2 = slice.parent();
        int n = slice.index();
        byte[] byArray3 = slice2.parent();
        int n2 = slice2.index();
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[n2 + i] = (byte)(byArray2[n + i] ^ byArray[i]);
        }
    }

    protected static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) throws CustCommException {
        if (byArray.length != byArray2.length) {
            throw new CustCommException("Internal error : Tried to XOR arrays of different lengths.");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) throws CustCommException {
        byte[] byArray3 = new byte[byArray.length];
        AuthUtils.xor(byArray, byArray2, byArray3);
        return byArray3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + byArray2.length + byArray3.length);
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray3);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("Big time error" + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static Slice hash(Slice slice) throws CustCommException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.reset();
            messageDigest.update(slice.get());
            return new Slice(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CustCommException("Error calculating hash value");
        }
    }

    protected static void hash(Slice slice, Slice slice2) throws CustCommException {
        slice2.set(AuthUtils.hash(slice).get());
    }

    public static byte[] hash(byte[] byArray) throws CustCommException {
        byte[] byArray2 = AuthUtils.hash(new Slice(byArray)).get();
        return byArray2;
    }

    public static void printByteArray(String string, byte[] byArray) {
    }

    public byte[] encrypt(byte[] byArray) throws CustCommException {
        byte[] byArray2 = AuthUtils.concat(AuthUtils.pad(byArray), AuthUtils.MAC(this.PRF(), byArray));
        return AuthUtils.xor(byArray2, this.PRF(byArray2.length));
    }

    public byte[] decrypt(byte[] byArray) throws CustCommException {
        int n;
        if (byArray.length < 20) {
            throw new CustCommException("Received message was too short");
        }
        byte[] byArray2 = this.PRF();
        byte[] byArray3 = AuthUtils.xor(byArray, this.PRF(byArray.length));
        byte[] byArray4 = new byte[byArray.length - 20];
        byte[] byArray5 = new byte[20];
        for (n = 0; n < byArray4.length; ++n) {
            byArray4[n] = byArray3[n];
        }
        for (int i = 0; i < byArray5.length; ++i) {
            byArray5[i] = byArray3[n];
            ++n;
        }
        byte[] byArray6 = AuthUtils.unpad(byArray4);
        byte[] byArray7 = AuthUtils.hash(byArray6);
        for (int i = 0; i < 20; ++i) {
            if (AuthUtils.MAC(byArray2, byArray6)[i] == byArray5[i]) continue;
            throw new AuthenticationErrorException("MAC validation failed");
        }
        return byArray6;
    }

    protected static byte[] pad(byte[] byArray) {
        return byArray;
    }

    protected static byte[] unpad(byte[] byArray) {
        return byArray;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            AuthUtils.opad[i] = 54;
            AuthUtils.ipad[i] = 92;
        }
    }
}

