/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.crypto.primes.EPrimeParameterException;
import com.cryptomathic.security.RSAPublicKey;
import com.cryptomathic.security.provider.KeyPairGeneratorRSA;
import com.cryptomathic.security.provider.Provider;
import com.cryptomathic.security.spec.RSAParameterSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public class CryptoUtils {
    private static byte[] removeFirstLeading0(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || byArray[0] != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static byte[] setTLV(byte by, byte[] byArray) {
        int n;
        byte[] byArray2 = null;
        int n2 = byArray.length;
        for (n = 4; n2 >> 8 * (n - 1) == 0 && n > 0; --n) {
        }
        if (n == 1 && (n2 & 0x80) == 0) {
            byArray2 = new byte[n2 + 2];
            byArray2[0] = by;
            byArray2[1] = (byte)n2;
            System.arraycopy(byArray, 0, byArray2, 2, n2);
            return byArray2;
        }
        byArray2 = new byte[n2 + n + 2];
        byArray2[0] = by;
        byArray2[1] = (byte)(n | 0x80);
        for (int i = 0; i < n; ++i) {
            int n3 = n - 1 - i;
            byArray2[i + 2] = (byte)((n2 & 255 << n3 * 8) >> n3 * 8);
        }
        System.arraycopy(byArray, 0, byArray2, 2 + n, n2);
        return byArray2;
    }

    public static KeyPair newRSAKeyPair() {
        Security.addProvider(new Provider());
        KeyPairGeneratorRSA keyPairGeneratorRSA = new KeyPairGeneratorRSA();
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "Cryptomathic");
            RSAParameterSpec rSAParameterSpec = null;
            rSAParameterSpec = new RSAParameterSpec(1024, new BigInteger("3"));
            keyPairGeneratorRSA.initialize(rSAParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("No such algorithm");
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.out.println("No such provider: Cryptomathic");
            return null;
        }
        catch (EPrimeParameterException ePrimeParameterException) {
            return null;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return null;
        }
        return keyPairGeneratorRSA.generateKeyPair();
    }

    public static byte[] RSAPublicKeyToPKCS1(RSAPublicKey rSAPublicKey) {
        byte[] byArray = CryptoUtils.setTLV((byte)2, rSAPublicKey.getPublicExponent().toByteArray());
        byte[] byArray2 = CryptoUtils.setTLV((byte)2, rSAPublicKey.getModulus().toByteArray());
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return CryptoUtils.setTLV((byte)48, byArray3);
    }

    private static byte[] getPayLoad(InputStream inputStream) throws IOException {
        int n;
        byte by = (byte)inputStream.read();
        int n2 = inputStream.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            int n3 = n2 & 0x7F;
            n = inputStream.read();
            while (--n3 > 0) {
                n <<= 8;
                n |= inputStream.read();
            }
        }
        if (n < 0) {
            throw new IOException("Bad encoding. Negative size.");
        }
        byte[] byArray = new byte[n];
        if (n != inputStream.read(byArray)) {
            throw new IOException("Bad encoding");
        }
        return byArray;
    }

    public static RSAPublicKey PKCS1ToRSAPublicKey(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new ByteArrayInputStream(CryptoUtils.getPayLoad(byteArrayInputStream));
        BigInteger bigInteger = new BigInteger(CryptoUtils.getPayLoad(byteArrayInputStream));
        BigInteger bigInteger2 = new BigInteger(CryptoUtils.getPayLoad(byteArrayInputStream));
        return new RSAPublicKey(bigInteger, bigInteger2);
    }
}

